/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.localsearch.DSETestGenerator;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testsuite.TestSuiteChromosome;

public class DSETestCaseLocalSearch
extends TestCaseLocalSearch {
    private final TestSuiteChromosome suite;

    private static boolean hasUncoveredBranch(TestChromosome test, Set<Branch> uncoveredBranches) {
        Set<Branch> testCoveredBranches = DSETestCaseLocalSearch.getCoveredBranches(test);
        for (Branch b : testCoveredBranches) {
            Branch negate = b.negate();
            if (!uncoveredBranches.contains(negate)) continue;
            return true;
        }
        return false;
    }

    public DSETestCaseLocalSearch() {
        this(null);
    }

    public DSETestCaseLocalSearch(TestSuiteChromosome suite) {
        this.suite = suite;
    }

    private static Set<Branch> collectUncoveredBranches(Set<Branch> coveredBranches) {
        HashSet<Branch> uncoveredBranches = new HashSet<Branch>();
        for (Branch b : coveredBranches) {
            Branch negate = b.negate();
            if (coveredBranches.contains(negate)) continue;
            uncoveredBranches.add(negate);
        }
        return uncoveredBranches;
    }

    @Override
    public boolean doSearch(TestChromosome test, LocalSearchObjective<TestChromosome> objective) {
        boolean fitnessHasImproved;
        logger.info("Test before local search: " + test.getTestCase().toCode());
        Set<Branch> coveredBranches = this.suite != null ? DSETestCaseLocalSearch.collectCoveredBranches(this.suite) : DSETestCaseLocalSearch.getCoveredBranches(test);
        Set<Branch> uncoveredBranches = DSETestCaseLocalSearch.collectUncoveredBranches(coveredBranches);
        if (uncoveredBranches.isEmpty()) {
            return false;
        }
        if (!DSETestCaseLocalSearch.hasUncoveredBranch(test, uncoveredBranches)) {
            return false;
        }
        Set<Integer> targetStatementIndexes = DSETestCaseLocalSearch.collectStatementIndexesWithSymbolicVariables(test, objective);
        if (targetStatementIndexes.isEmpty()) {
            fitnessHasImproved = false;
        } else {
            logger.info("Yes, now applying the search at positions {}!", targetStatementIndexes);
            DSETestGenerator dseTestGenerator = this.suite != null ? new DSETestGenerator(this.suite) : new DSETestGenerator();
            TestChromosome newTest = dseTestGenerator.generateNewTest(test, targetStatementIndexes, objective);
            fitnessHasImproved = newTest != null;
        }
        LocalSearchBudget.getInstance().countLocalSearchOnTest();
        return fitnessHasImproved;
    }

    private static Set<Integer> collectStatementIndexesWithSymbolicVariables(TestChromosome testChromosome, LocalSearchObjective<TestChromosome> localSearchObjective) {
        Integer lastPos;
        int lastPosition = testChromosome.size() - 1;
        if (testChromosome.getLastExecutionResult() != null && !testChromosome.isChanged() && (lastPos = testChromosome.getLastExecutionResult().getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        TestCase test = testChromosome.getTestCase();
        HashSet<Integer> targetStatementIndexes = new HashSet<Integer>();
        for (int i = lastPosition; i >= 0 && !LocalSearchBudget.getInstance().isFinished() && !localSearchObjective.isDone(); --i) {
            if (i >= testChromosome.size()) {
                logger.warn("Test size decreased unexpectedly during local search, aborting local search");
                logger.warn(testChromosome.getTestCase().toCode());
                break;
            }
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (!test.hasReferences(test.getStatement(i).getReturnValue()) && !test.getStatement(i).getReturnClass().equals(targetClass)) {
                logger.info("Return value of statement " + i + " is not referenced and not SUT, not doing local search");
                continue;
            }
            targetStatementIndexes.add(i);
        }
        return targetStatementIndexes;
    }

    private static Set<Branch> collectCoveredBranches(TestSuiteChromosome suite) {
        HashSet<Branch> suiteCoveredBranches = new HashSet<Branch>();
        for (TestChromosome test : suite.getTestChromosomes()) {
            Set<Branch> testCoveredBranches = DSETestCaseLocalSearch.getCoveredBranches(test);
            suiteCoveredBranches.addAll(testCoveredBranches);
        }
        return suiteCoveredBranches;
    }

    private static Set<Branch> getCoveredBranches(TestChromosome test) {
        Branch b;
        HashSet<Branch> testCoveredBranches = new HashSet<Branch>();
        ExecutionTrace trace = test.getLastExecutionResult().getTrace();
        Set<Integer> coveredTrueBranchIndexesInTrace = trace.getCoveredTrueBranches();
        for (Integer branchIndex : coveredTrueBranchIndexesInTrace) {
            b = new Branch(branchIndex, true);
            testCoveredBranches.add(b);
        }
        Set<Integer> coveredFalseBranchIndexesInTrace = trace.getCoveredFalseBranches();
        for (Integer branchIndex : coveredFalseBranchIndexesInTrace) {
            b = new Branch(branchIndex, false);
            testCoveredBranches.add(b);
        }
        return testCoveredBranches;
    }

    private static class Branch {
        private int branchIndex;
        private boolean isTrueBranch;

        public Branch(int branchIndex, boolean isTrueBranch) {
            this.branchIndex = branchIndex;
            this.isTrueBranch = isTrueBranch;
        }

        public Branch negate() {
            return new Branch(this.branchIndex, !this.isTrueBranch);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.branchIndex;
            result = 31 * result + (this.isTrueBranch ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Branch other = (Branch)obj;
            if (this.branchIndex != other.branchIndex) {
                return false;
            }
            return this.isTrueBranch == other.isTrueBranch;
        }

        public String toString() {
            return "Branch [branchIndex=" + this.branchIndex + ", isTrueBranch=" + this.isTrueBranch + "]";
        }
    }
}

