/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatLocalSearch<T extends Number>
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseLocalSearch.class);
    private T oldValue;

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        TestCase slice = test.getTestCase().clone();
        int newPos = slice.sliceFor(slice.getStatement(statement).getReturnValue());
        TestCase oldTest = test.getTestCase();
        test.setTestCase(slice);
        test.setChanged(true);
        int oldStatement = statement;
        statement = newPos;
        boolean improved = false;
        NumericalPrimitiveStatement p = (NumericalPrimitiveStatement)test.getTestCase().getStatement(statement);
        double value = ((Number)p.getValue()).doubleValue();
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return false;
        }
        logger.info("Applying search to: " + p.getCode());
        int change = this.doSearch(test, statement, objective, 1.0, 2.0, p);
        if (change == 0) {
            logger.info("Stopping search as variable doesn't influence fitness");
            test.setTestCase(oldTest);
            return improved;
        }
        improved = true;
        logger.info("Checking after the comma: " + p.getCode());
        int maxPrecision = ((Number)p.getValue()).getClass().equals(Float.class) ? 7 : 15;
        for (int precision = 1; precision <= maxPrecision && !LocalSearchBudget.getInstance().isFinished(); ++precision) {
            this.roundPrecision(test, objective, precision, p);
            logger.debug("Current precision: " + precision);
            change = this.doSearch(test, statement, objective, Math.pow(10.0, -precision), 2.0, p);
            if (change >= 0) continue;
            improved = true;
        }
        logger.debug("Finished local search with result " + p.getCode());
        if (improved) {
            NumericalPrimitiveStatement ps = (NumericalPrimitiveStatement)oldTest.getStatement(oldStatement);
            ps.setValue(p.getValue());
        }
        test.setChanged(true);
        test.setTestCase(oldTest);
        return improved;
    }

    private boolean roundPrecision(TestChromosome test, LocalSearchObjective<TestChromosome> objective, int precision, NumericalPrimitiveStatement<T> p) {
        double value = ((Number)p.getValue()).doubleValue();
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return false;
        }
        BigDecimal bd = new BigDecimal(value).setScale(precision, RoundingMode.HALF_EVEN);
        if (bd.doubleValue() == value) {
            return false;
        }
        double newValue = bd.doubleValue();
        this.oldValue = (Number)p.getValue();
        ExecutionResult oldResult = test.getLastExecutionResult();
        if (((Number)p.getValue()).getClass().equals(Float.class)) {
            p.setValue(new Float(newValue));
        } else {
            p.setValue((Float)((Object)new Double(newValue)));
        }
        logger.info("Trying to chop precision " + precision + ": " + value + " -> " + newValue);
        if (objective.hasNotWorsened(test)) {
            return true;
        }
        logger.info("Restoring old value: " + value);
        p.setValue((Float)this.oldValue);
        test.setLastExecutionResult(oldResult);
        test.setChanged(false);
        return false;
    }

    private int doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective, double initialDelta, double factor, NumericalPrimitiveStatement<T> p) {
        int changed = 0;
        this.oldValue = (Number)p.getValue();
        ExecutionResult oldResult = test.getLastExecutionResult();
        boolean done = false;
        while (!done) {
            done = true;
            p.increment(initialDelta);
            logger.info("Trying increment of " + p.getCode());
            int change = objective.hasChanged(test);
            if (change != 0) {
                changed = change;
            }
            if (change < 0) {
                done = false;
                this.iterate(factor * initialDelta, factor, objective, test, p, statement);
                this.oldValue = (Number)p.getValue();
                oldResult = test.getLastExecutionResult();
                continue;
            }
            p.setValue(this.oldValue);
            test.setLastExecutionResult(oldResult);
            test.setChanged(false);
            p.increment(-initialDelta);
            logger.info("Trying decrement of " + p.getCode());
            change = objective.hasChanged(test);
            if (change < 0) {
                logger.info("Iterating because of improvement");
                changed = change;
                done = false;
                this.iterate(-factor * initialDelta, factor, objective, test, p, statement);
                this.oldValue = (Number)p.getValue();
                oldResult = test.getLastExecutionResult();
                continue;
            }
            logger.info("Not iterating because no improvement");
            p.setValue(this.oldValue);
            test.setLastExecutionResult(oldResult);
            test.setChanged(false);
        }
        logger.debug("Finished local search with result " + p.getCode());
        return changed;
    }

    private boolean iterate(double delta, double factor, LocalSearchObjective<TestChromosome> objective, TestChromosome test, NumericalPrimitiveStatement<T> p, int statement) {
        boolean improvement = false;
        Number oldValue = (Number)p.getValue();
        ExecutionResult oldResult = test.getLastExecutionResult();
        logger.info("Trying increment " + delta + " of " + p.getCode());
        p.increment(delta);
        while (objective.hasImproved(test)) {
            oldValue = (Number)p.getValue();
            oldResult = test.getLastExecutionResult();
            test.setChanged(false);
            improvement = true;
            delta = factor * delta;
            logger.info("Trying increment " + delta + " of " + p.getCode());
            p.increment(delta);
        }
        p.setValue(oldValue);
        test.setLastExecutionResult(oldResult);
        test.setChanged(false);
        return improvement;
    }
}

