/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.Properties;
import org.evosuite.dse.VM;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.UncompilableCodeException;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericConstructor;

public class ConstructorStatement
extends EntityWithParametersStatement {
    private static final long serialVersionUID = -3035570485633271957L;
    private GenericConstructor constructor;
    private static final List<String> primitiveClasses = Arrays.asList("char", "int", "short", "long", "boolean", "float", "double", "byte");

    public ConstructorStatement(TestCase tc, GenericConstructor constructor, List<VariableReference> parameters) {
        super(tc, new VariableReferenceImpl(tc, constructor.getOwnerClass()), parameters, constructor.getConstructor().getAnnotations(), constructor.getConstructor().getParameterAnnotations());
        this.constructor = constructor;
    }

    public ConstructorStatement(TestCase tc, GenericConstructor constructor, VariableReference retvar, List<VariableReference> parameters) {
        super(tc, retvar, parameters, constructor.getConstructor().getAnnotations(), constructor.getConstructor().getParameterAnnotations());
        assert (tc.size() > retvar.getStPosition());
        this.constructor = constructor;
    }

    protected ConstructorStatement(TestCase tc, GenericConstructor constructor, VariableReference retvar, List<VariableReference> parameters, boolean check) {
        super(tc, retvar, parameters, constructor.getConstructor().getAnnotations(), constructor.getConstructor().getParameterAnnotations());
        assert (!check);
        this.constructor = constructor;
    }

    public GenericConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(GenericConstructor constructor) {
        this.constructor = constructor;
        this.retval.setType(constructor.getReturnType());
    }

    public static String getReturnType(Class<?> clazz) {
        String retVal = ClassUtils.getShortClassName(clazz);
        if (primitiveClasses.contains(retVal)) {
            return clazz.getSimpleName();
        }
        return retVal;
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        logger.trace("Executing constructor " + this.constructor.toString());
        final Object[] inputs = new Object[this.parameters.size()];
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Type[] parameterTypes = ConstructorStatement.this.constructor.getParameterTypes();
                    for (int i = 0; i < ConstructorStatement.this.parameters.size(); ++i) {
                        VariableReference parameterVar = (VariableReference)ConstructorStatement.this.parameters.get(i);
                        try {
                            inputs[i] = parameterVar.getObject(scope);
                        }
                        catch (CodeUnderTestException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            AbstractStatement.logger.error("Class " + Properties.TARGET_CLASS + ". Error encountered: " + e);
                            assert (false);
                            throw new EvosuiteError(e);
                        }
                        if (inputs[i] != null && !TypeUtils.isAssignable(inputs[i].getClass(), (Type)parameterTypes[i])) {
                            throw new CodeUnderTestException(new UncompilableCodeException("Cannot assign " + parameterVar.getVariableClass().getName() + " to " + parameterTypes[i]));
                        }
                        if (inputs[i] != null || !ConstructorStatement.this.constructor.getConstructor().getParameterTypes()[i].isPrimitive()) continue;
                        throw new CodeUnderTestException(new NullPointerException());
                    }
                    if (ConstructorStatement.this.constructor.getConstructor().getDeclaringClass().isMemberClass() && !Modifier.isStatic(ConstructorStatement.this.constructor.getConstructor().getDeclaringClass().getModifiers()) && inputs[0] == null) {
                        throw new CodeUnderTestException(new NullPointerException());
                    }
                    Object ret = ConstructorStatement.this.constructor.getConstructor().newInstance(inputs);
                    try {
                        ConstructorStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    LinkedHashSet<Class<? extends Throwable>> t = new LinkedHashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            VM.disableCallBacks();
            exceptionThrown = e.getCause();
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("Exception thrown in constructor: " + e.getCause());
                }
                catch (Exception ex) {
                    logger.debug("Exception thrown in constructor and SUT gives issue when calling e.getCause()", (Throwable)ex);
                }
            }
            return exceptionThrown;
        }
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        ArrayList<VariableReference> new_params = new ArrayList<VariableReference>();
        for (VariableReference r : this.parameters) {
            new_params.add(r.copy(newTestCase, offset));
        }
        ConstructorStatement copy = new ConstructorStatement(newTestCase, this.constructor.copy(), new_params);
        return copy;
    }

    @Override
    public List<VariableReference> getParameterReferences() {
        return this.parameters;
    }

    @Override
    public int getNumParameters() {
        return this.parameters.size();
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ConstructorStatement ms = (ConstructorStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.constructor.equals(ms.constructor)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((VariableReference)this.parameters.get(i)).equals(ms.parameters.get(i))) continue;
            return false;
        }
        return this.retval.equals(ms.retval);
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 41 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        Set<Class<?>> ex = super.getDeclaredExceptions();
        ex.addAll(Arrays.asList(this.constructor.getConstructor().getExceptionTypes()));
        return ex;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        if (Randomness.nextDouble() >= Properties.P_CHANGE_PARAMETER) {
            return false;
        }
        Constraints constraint = this.constructor.getConstructor().getAnnotation(Constraints.class);
        if (constraint != null && constraint.notMutable()) {
            return false;
        }
        List<VariableReference> parameters = this.getParameterReferences();
        if (parameters.isEmpty()) {
            return false;
        }
        double pParam = 1.0 / (double)parameters.size();
        boolean changed = false;
        for (int numParameter = 0; numParameter < parameters.size(); ++numParameter) {
            if (!(Randomness.nextDouble() < pParam) || !this.mutateParameter(test, numParameter)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isAccessible() {
        if (!this.constructor.isAccessible()) {
            return false;
        }
        return super.isAccessible();
    }

    @Override
    public boolean isValid() {
        assert (super.isValid());
        for (VariableReference v : this.parameters) {
            v.getStPosition();
        }
        return true;
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ConstructorStatement ms = (ConstructorStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.constructor.equals(ms.constructor)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((VariableReference)this.parameters.get(i)).same((VariableReference)ms.parameters.get(i))) continue;
            return false;
        }
        return this.retval.same(ms.retval);
    }

    public GenericConstructor getAccessibleObject() {
        return this.constructor;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.constructor.changeClassLoader(loader);
        super.changeClassLoader(loader);
    }

    public String toString() {
        return this.constructor.getName() + org.objectweb.asm.Type.getConstructorDescriptor(this.constructor.getConstructor());
    }

    @Override
    public String getDescriptor() {
        return this.constructor.getDescriptor();
    }

    @Override
    public String getDeclaringClassName() {
        return this.constructor.getDeclaringClass().getCanonicalName();
    }

    @Override
    public String getMethodName() {
        return "<init>";
    }
}

