/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.variable;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import org.evosuite.runtime.Reflection;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericField;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReference
extends VariableReferenceImpl {
    private static final long serialVersionUID = 834164966411781655L;
    private final Logger logger = LoggerFactory.getLogger(FieldReference.class);
    private final GenericField field;
    private VariableReference source;

    public FieldReference(TestCase testCase, GenericField field, VariableReference source) {
        super(testCase, field.getFieldType());
        assert (source != null || field.isStatic()) : "No source object was supplied, therefore we assumed the field to be static. However asking the field if it was static, returned false";
        this.field = field;
        this.source = source;
    }

    public FieldReference(TestCase testCase, GenericField field, Type fieldType, VariableReference source) {
        super(testCase, fieldType);
        assert (field != null);
        assert (source != null || field.isStatic()) : "No source object was supplied, therefore we assumed the field to be static. However asking the field if it was static, returned false";
        this.field = field;
        this.source = source;
        assert (source == null || field.getField().getDeclaringClass().isAssignableFrom(source.getVariableClass())) : "Assertion! Declaring class: " + field.getField().getDeclaringClass() + " # classloader: " + field.getField().getDeclaringClass().getClassLoader() + " | Variable Class: " + source.getVariableClass() + " # classloader: " + source.getVariableClass().getClassLoader() + " | Field name: " + field.getField();
    }

    public FieldReference(TestCase testCase, GenericField field) {
        super(testCase, field.getFieldType());
        this.field = field;
        this.source = null;
    }

    public FieldReference(TestCase testCase, GenericField field, Type type) {
        super(testCase, type);
        this.field = field;
        this.source = null;
    }

    public GenericField getField() {
        return this.field;
    }

    public VariableReference getSource() {
        return this.source;
    }

    @Override
    public Object getObject(Scope scope) throws CodeUnderTestException {
        Object s = this.field.isStatic() ? null : this.source.getObject(scope);
        try {
            return this.field.getField().get(s);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Error accessing field " + this.field + " of object " + this.source + ": " + e, (Throwable)e);
            throw new CodeUnderTestException(e.getCause());
        }
        catch (IllegalAccessException e) {
            this.logger.error("Error accessing field " + this.field + " of object " + this.source + ": " + e, (Throwable)e);
            throw new EvosuiteError(e);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | NullPointerException e) {
            throw new CodeUnderTestException(e);
        }
    }

    @Override
    public void setObject(Scope scope, Object value) throws CodeUnderTestException {
        Object sourceObject = null;
        try {
            if (this.source != null) {
                sourceObject = this.source.getObject(scope);
                if (sourceObject == null) {
                    throw new CodeUnderTestException(new NullPointerException());
                }
                if (!this.field.getField().getDeclaringClass().isAssignableFrom(sourceObject.getClass())) {
                    throw new CodeUnderTestException(new IllegalArgumentException("Cannot assignable: " + value + " of class " + value.getClass() + " to field " + this.field + " of variable " + this.source));
                }
            }
            Reflection.setField((Field)this.field.getField(), (Object)sourceObject, (Object)value);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Error while assigning field: " + this.getName() + " with value " + value + " on object " + sourceObject + ": " + e, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            this.logger.error("Error while assigning field: " + this.field.getField().toString() + " of type: " + this.field.getField().getType().getCanonicalName() + " " + e, (Throwable)e);
            throw new EvosuiteError(e);
        }
        catch (NullPointerException e) {
            throw new CodeUnderTestException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw new CodeUnderTestException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new EvosuiteError(e);
        }
    }

    @Override
    public VariableReference getAdditionalVariableReference() {
        if (this.source != null && this.source.getAdditionalVariableReference() != null) {
            return this.source.getAdditionalVariableReference();
        }
        return this.source;
    }

    @Override
    public void setAdditionalVariableReference(VariableReference var) {
        if (this.source != null && !this.field.getField().getDeclaringClass().isAssignableFrom(var.getVariableClass())) {
            this.logger.info("Not assignable: " + this.field.getField().getDeclaringClass() + " and " + var);
            assert (false);
        }
        this.source = var;
    }

    @Override
    public void replaceAdditionalVariableReference(VariableReference var1, VariableReference var2) {
        if (this.source != null) {
            if (this.source.equals(var1)) {
                if (var2 instanceof ConstantValue && ((ConstantValue)var2).getValue() == null) {
                    return;
                }
                this.source = var2;
            } else {
                this.source.replaceAdditionalVariableReference(var1, var2);
            }
        }
    }

    @Override
    public int getStPosition() {
        int i;
        for (i = 0; i < this.testCase.size(); ++i) {
            if (!this.testCase.getStatement(i).getReturnValue().equals(this)) continue;
            return i;
        }
        if (this.source != null) {
            return this.source.getStPosition();
        }
        for (i = 0; i < this.testCase.size(); ++i) {
            if (!this.testCase.getStatement(i).references(this)) continue;
            return i;
        }
        throw new AssertionError((Object)"A VariableReferences position is only defined if the VariableReference is defined by a statement in the testCase.");
    }

    @Override
    public String getName() {
        if (this.source != null) {
            return this.source.getName() + "." + this.field.getName();
        }
        return this.field.getOwnerClass().getSimpleName() + "." + this.field.getName();
    }

    @Override
    public String toString() {
        return "FieldReference: " + this.getName() + ", Statement " + this.getStPosition() + ", type " + this.type.getTypeName();
    }

    @Override
    public VariableReference copy(TestCase newTestCase, int offset) {
        Type fieldType = this.field.getFieldType();
        if (this.source != null) {
            VariableReference otherSource = this.source.copy(newTestCase, offset);
            return new FieldReference(newTestCase, this.field.copy(), fieldType, otherSource);
        }
        return new FieldReference(newTestCase, this.field.copy(), fieldType);
    }

    public int getDepth() {
        int depth = 1;
        if (this.source instanceof FieldReference) {
            depth += ((FieldReference)this.source).getDepth();
        }
        return depth;
    }

    @Override
    public boolean isAccessible() {
        return this.field.isAccessible();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldReference other = (FieldReference)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    private boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public boolean isFieldReference() {
        return true;
    }

    @Override
    public void loadBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        if (!this.isStatic()) {
            this.source.loadBytecode(mg, locals);
            mg.getField(org.objectweb.asm.Type.getType(this.source.getVariableClass()), this.field.getName(), org.objectweb.asm.Type.getType(this.getVariableClass()));
        } else {
            mg.getStatic(org.objectweb.asm.Type.getType(this.source.getVariableClass()), this.field.getName(), org.objectweb.asm.Type.getType(this.getVariableClass()));
        }
    }

    @Override
    public void storeBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        if (!this.isStatic()) {
            this.source.loadBytecode(mg, locals);
            mg.swap();
            mg.putField(org.objectweb.asm.Type.getType(this.source.getVariableClass()), this.field.getName(), org.objectweb.asm.Type.getType(this.getVariableClass()));
        } else {
            mg.putStatic(org.objectweb.asm.Type.getType(this.source.getVariableClass()), this.field.getName(), org.objectweb.asm.Type.getType(this.getVariableClass()));
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.field.changeClassLoader(loader);
        if (!this.isStatic()) {
            this.source.changeClassLoader(loader);
        }
        super.changeClassLoader(loader);
    }
}

