/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverCache;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DeprecatedTestSuiteDSE {
    private static final Logger logger = LoggerFactory.getLogger(DeprecatedTestSuiteDSE.class);
    private static int nrConstraints = 0;
    private static int nrSolvedConstraints = 0;
    private int nrCurrConstraints = 0;
    private static int success = 0;
    private static int failed = 0;
    private LocalSearchObjective<TestSuiteChromosome> objective;
    private final Map<TestChromosome, List<BranchCondition>> pathConditions = new HashMap<TestChromosome, List<BranchCondition>>();
    private final Set<BranchCondition> unsolvableBranchConditions = new HashSet<BranchCondition>();
    private final Map<String, Integer> solutionAttempts = new HashMap<String, Integer>();
    private Collection<TestBranchPair> unsolvedBranchConditions = null;

    private void calculateUncoveredBranches() {
        this.unsolvedBranchConditions.clear();
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            for (TestChromosome testChromosome : this.pathConditions.keySet()) {
                List<BranchCondition> pathCondition = this.pathConditions.get(testChromosome);
                for (BranchCondition branch : pathCondition) {
                    if (this.unsolvableBranchConditions.contains(branch)) continue;
                    this.unsolvedBranchConditions.add(new TestBranchPair(testChromosome, pathCondition, branch));
                }
            }
        } else {
            HashMap solvedConstraints = new HashMap();
            for (TestChromosome test : this.pathConditions.keySet()) {
                List<BranchCondition> pathCondition = this.pathConditions.get(test);
                for (BranchCondition branch : pathCondition) {
                    if (this.unsolvableBranchConditions.contains(branch)) continue;
                    String index = this.getBranchIndex(branch);
                    if (!solvedConstraints.containsKey(index)) {
                        solvedConstraints.put(index, new HashMap());
                    }
                    Constraint<?> c = branch.getConstraint();
                    if (!((Map)solvedConstraints.get(index)).containsKey((Object)c.getComparator())) {
                        ((Map)solvedConstraints.get(index)).put(c.getComparator(), new HashSet());
                    }
                    ((Set)((Map)solvedConstraints.get(index)).get((Object)c.getComparator())).add(new TestBranchPair(test, pathCondition, branch));
                }
            }
            for (String index : solvedConstraints.keySet()) {
                if (((Map)solvedConstraints.get(index)).size() != 1) continue;
                Set branches = (Set)((Map)solvedConstraints.get(index)).values().iterator().next();
                this.unsolvedBranchConditions.addAll(branches);
            }
            logger.info("Update set of unsolved branch conditions to " + this.unsolvedBranchConditions.size());
            if (!Properties.DSE_RANK_BRANCH_CONDITIONS) {
                Randomness.shuffle((ArrayList)this.unsolvedBranchConditions);
            }
        }
    }

    private void updatePathConstraints(TestChromosome test) {
        List<BranchCondition> pathCondition = ConcolicExecution.getSymbolicPath(test);
        this.pathConditions.put(test, pathCondition);
    }

    private void createPathConstraints(TestSuiteChromosome testSuite) {
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            this.updatePathConstraints(test);
        }
        this.calculateUncoveredBranches();
    }

    private String getBranchIndex(BranchCondition branch) {
        return branch.getFullName() + branch.getInstructionIndex();
    }

    private TestBranchPair getNextBranchCondition() {
        TestBranchPair pair = this.getNextTestBranchPair();
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            return pair;
        }
        String index = this.getBranchIndex(pair.branch);
        if (!this.unsolvedBranchConditions.isEmpty()) {
            while (this.solutionAttempts.containsKey(index) && this.solutionAttempts.get(index) >= Properties.CONSTRAINT_SOLUTION_ATTEMPTS && !this.unsolvedBranchConditions.isEmpty()) {
                logger.info("Reached maximum number of attempts for branch " + index);
                pair = this.getNextTestBranchPair();
                index = this.getBranchIndex(pair.branch);
            }
        }
        if (!this.solutionAttempts.containsKey(index)) {
            this.solutionAttempts.put(index, 1);
        } else {
            this.solutionAttempts.put(index, this.solutionAttempts.get(index) + 1);
        }
        return pair;
    }

    private TestBranchPair getNextTestBranchPair() {
        TestBranchPair pair = Properties.DSE_RANK_BRANCH_CONDITIONS ? (TestBranchPair)((PriorityQueue)this.unsolvedBranchConditions).poll() : (TestBranchPair)((ArrayList)this.unsolvedBranchConditions).remove(0);
        return pair;
    }

    private boolean hasNextBranchCondition() {
        return !this.unsolvedBranchConditions.isEmpty();
    }

    private TestCase negateCondition(Set<Constraint<?>> reachingConstraints, Constraint<?> localConstraint, TestCase test) {
        List<Constraint<?>> constraints = new LinkedList();
        constraints.addAll(reachingConstraints);
        Constraint<?> targetConstraint = localConstraint.negate();
        constraints.add(targetConstraint);
        if (!targetConstraint.isSolveable()) {
            logger.info("Found unsolvable constraint: " + targetConstraint);
            return null;
        }
        int size = constraints.size();
        if (size > 0) {
            logger.debug("Calculating cone of influence for " + size + " constraints");
            constraints = this.reduce(constraints);
            logger.info("Reduced constraints from " + size + " to " + constraints.size());
        }
        this.nrCurrConstraints = constraints.size();
        nrConstraints += this.nrCurrConstraints;
        logger.info("Applying local search");
        Solver solver = SolverFactory.getInstance().buildNewSolver();
        DSEStats.getInstance().reportNewConstraints(constraints);
        long startSolvingTime = System.currentTimeMillis();
        SolverCache solverCache = SolverCache.getInstance();
        SolverResult solverResult = solverCache.solve(solver, constraints);
        long estimatedSolvingTime = System.currentTimeMillis() - startSolvingTime;
        DSEStats.getInstance().reportNewSolvingTime(estimatedSolvingTime);
        if (solverResult == null) {
            logger.info("Found no solution");
            return null;
        }
        if (solverResult.isUNSAT()) {
            logger.info("Found UNSAT solution");
            DSEStats.getInstance().reportNewUNSAT();
            return null;
        }
        Map<String, Object> model = solverResult.getModel();
        DSEStats.getInstance().reportNewSAT();
        TestCase newTest = test.clone();
        for (String key : model.keySet()) {
            Object val = model.get(key);
            if (val != null) {
                PrimitiveStatement<?> p;
                String name;
                Number value;
                logger.info("New value: " + key + ": " + val);
                if (val instanceof Long) {
                    value = (Long)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    if (p.getValue().getClass().equals(Character.class)) {
                        p.setValue(Character.valueOf((char)((Long)value).intValue()));
                        continue;
                    }
                    if (p.getValue().getClass().equals(Long.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Integer.class)) {
                        p.setValue(((Long)value).intValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Short.class)) {
                        p.setValue(((Long)value).shortValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Boolean.class)) {
                        p.setValue(((Long)value).intValue() > 0);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Byte.class)) {
                        p.setValue(((Long)value).byteValue() > 0);
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + p.getValue().getClass() + val);
                    continue;
                }
                if (val instanceof String) {
                    String name2 = key.replace("__SYM", "");
                    PrimitiveStatement<?> p2 = this.getStatement(newTest, name2);
                    assert (p2 != null) : "Could not find variable " + name2 + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p2.getValue().getClass().equals(Character.class)) {
                        p2.setValue(Character.valueOf((char)Integer.parseInt(val.toString())));
                        continue;
                    }
                    p2.setValue(val.toString());
                    continue;
                }
                if (val instanceof Double) {
                    value = (Double)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    assert (p != null) : "Could not find variable " + name + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p.getValue().getClass().equals(Double.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Float.class)) {
                        p.setValue(Float.valueOf(((Double)value).floatValue()));
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + val);
                    continue;
                }
                logger.debug("New value is of an unsupported type: " + val);
                continue;
            }
            logger.debug("New value is null");
        }
        return newTest;
    }

    private PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (Statement statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = this.getVariables(target);
        LinkedList coi = new LinkedList();
        if (dependencies.size() <= 0) {
            return coi;
        }
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = this.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        DeprecatedTestSuiteDSE.getVariables(constraint.getLeftOperand(), variables);
        DeprecatedTestSuiteDSE.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    private static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        variables.addAll(expr.getVariables());
    }

    private double getFitness(TestSuiteChromosome suite) {
        for (FitnessFunction<Chromosome> ff : this.objective.getFitnessFunctions()) {
            TestSuiteFitnessFunction tff = (TestSuiteFitnessFunction)ff;
            tff.getFitness(suite);
        }
        return suite.getFitness();
    }

    private boolean reachesUncoveredBranch(TestChromosome test, Set<Branch> uncoveredBranches) {
        Set<Branch> testCoveredBranches = DeprecatedTestSuiteDSE.getCoveredBranches(test);
        for (Branch b : testCoveredBranches) {
            Branch negate = b.negate();
            if (!uncoveredBranches.contains(negate)) continue;
            return true;
        }
        return false;
    }

    private static Set<Branch> getUncoveredBranches(Set<Branch> coveredBranches) {
        HashSet<Branch> uncoveredBranches = new HashSet<Branch>();
        for (Branch b : coveredBranches) {
            Branch negate = b.negate();
            if (coveredBranches.contains(negate)) continue;
            uncoveredBranches.add(negate);
        }
        return uncoveredBranches;
    }

    private static Set<Branch> getCoveredBranches(TestSuiteChromosome suite) {
        HashSet<Branch> suiteCoveredBranches = new HashSet<Branch>();
        for (TestChromosome test : suite.getTestChromosomes()) {
            Set<Branch> testCoveredBranches = DeprecatedTestSuiteDSE.getCoveredBranches(test);
            suiteCoveredBranches.addAll(testCoveredBranches);
        }
        return suiteCoveredBranches;
    }

    private static Set<Branch> getCoveredBranches(TestChromosome test) {
        Branch b;
        HashSet<Branch> testCoveredBranches = new HashSet<Branch>();
        ExecutionTrace trace = test.getLastExecutionResult().getTrace();
        Set<Integer> coveredTrueBranchIndexesInTrace = trace.getCoveredTrueBranches();
        for (Integer branchIndex : coveredTrueBranchIndexesInTrace) {
            b = new Branch(branchIndex, true);
            testCoveredBranches.add(b);
        }
        Set<Integer> coveredFalseBranchIndexesInTrace = trace.getCoveredFalseBranches();
        for (Integer branchIndex : coveredFalseBranchIndexesInTrace) {
            b = new Branch(branchIndex, false);
            testCoveredBranches.add(b);
        }
        return testCoveredBranches;
    }

    public boolean applyDSE0(TestSuiteChromosome individual) {
        logger.info("[DSE] Current test suite: " + individual.toString());
        boolean wasSuccess = false;
        TestSuiteChromosome expandedTests = individual.clone();
        this.createPathConstraints(expandedTests);
        double originalFitness = this.getFitness(individual);
        while (this.hasNextBranchCondition() && !LocalSearchBudget.getInstance().isFinished()) {
            logger.info("Branches remaining: " + this.unsolvedBranchConditions.size());
            TestBranchPair next = this.getNextBranchCondition();
            BranchCondition branch = next.branch;
            List<BranchCondition> pathCondition = next.pathCondition;
            LinkedList reachingConstraints = new LinkedList();
            for (BranchCondition b : pathCondition) {
                reachingConstraints.addAll(b.getSupportingConstraints());
                if (b == branch) break;
                reachingConstraints.add(b.getConstraint());
            }
            LinkedList constraints = new LinkedList();
            TestCase newTest = this.negateCondition(new HashSet(reachingConstraints), branch.getConstraint(), next.test.getTestCase());
            if (newTest != null) {
                logger.info("Found new test: " + newTest.toCode());
                TestChromosome newTestChromosome = new TestChromosome();
                newTestChromosome.setTestCase(newTest);
                expandedTests.addTest(newTestChromosome);
                if (Properties.DSE_KEEP_ALL_TESTS) {
                    this.updatePathConstraints(newTestChromosome);
                    this.calculateUncoveredBranches();
                    individual.addTest(newTest);
                    wasSuccess = true;
                } else if (this.getFitness(expandedTests) < originalFitness) {
                    logger.info("New test improves fitness to {}", (Object)this.getFitness(expandedTests));
                    DSEStats.getInstance().reportNewTestUseful();
                    wasSuccess = true;
                    this.updatePathConstraints(newTestChromosome);
                    this.calculateUncoveredBranches(newTestChromosome);
                    individual.addTest(newTest);
                    originalFitness = this.getFitness(expandedTests);
                } else {
                    logger.info("New test does not improve fitness");
                    DSEStats.getInstance().reportNewTestUnuseful();
                    expandedTests.deleteTest(newTest);
                }
                ++success;
                continue;
            }
            this.unsolvableBranchConditions.add(branch);
            ++failed;
            logger.info("Failed to find new test.");
        }
        logger.info("Finished DSE");
        this.getFitness(individual);
        LocalSearchBudget.getInstance().countLocalSearchOnTestSuite();
        return wasSuccess;
    }

    private void calculateUncoveredBranches(TestChromosome newTestChromosome) {
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            List<BranchCondition> pathCondition = this.pathConditions.get(newTestChromosome);
            for (BranchCondition targetBranchCondition : pathCondition) {
                if (this.unsolvableBranchConditions.contains(targetBranchCondition)) continue;
                this.unsolvedBranchConditions.add(new TestBranchPair(newTestChromosome, pathCondition, targetBranchCondition));
            }
        } else {
            this.calculateUncoveredBranches();
        }
    }

    private class TestBranchPair
    implements Comparable<TestBranchPair> {
        TestChromosome test;
        BranchCondition branch;
        List<BranchCondition> pathCondition;
        private final double ranking;

        TestBranchPair(TestChromosome test, List<BranchCondition> pathCondition, BranchCondition branchCondition) {
            this.test = test;
            this.branch = branchCondition;
            this.pathCondition = pathCondition;
            this.ranking = this.computeRanking(pathCondition, branchCondition);
        }

        private double computeRanking(List<BranchCondition> pathCondition, BranchCondition targetBranch) {
            LinkedList reachingConstraints = new LinkedList();
            for (BranchCondition b : pathCondition) {
                reachingConstraints.addAll(b.getSupportingConstraints());
                reachingConstraints.add(b.getConstraint());
                if (b != targetBranch) continue;
                break;
            }
            int length = 1 + reachingConstraints.size();
            int totalSize = 0;
            for (Constraint constraint : reachingConstraints) {
                totalSize += constraint.getSize();
            }
            double avg_size = (double)totalSize / (double)reachingConstraints.size();
            double ranking = (double)length * avg_size;
            return ranking;
        }

        @Override
        public int compareTo(TestBranchPair arg0) {
            return Double.compare(this.ranking, arg0.ranking);
        }
    }

    private static class Branch {
        private int branchIndex;
        private boolean isTrueBranch;

        public Branch(int branchIndex, boolean isTrueBranch) {
            this.branchIndex = branchIndex;
            this.isTrueBranch = isTrueBranch;
        }

        public Branch negate() {
            return new Branch(this.branchIndex, !this.isTrueBranch);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.branchIndex;
            result = 31 * result + (this.isTrueBranch ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Branch other = (Branch)obj;
            if (this.branchIndex != other.branchIndex) {
                return false;
            }
            return this.isTrueBranch == other.isTrueBranch;
        }

        public String toString() {
            return "Branch [branchIndex=" + this.branchIndex + ", isTrueBranch=" + this.isTrueBranch + "]";
        }
    }
}

