/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.secondaryobjectives;

import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testsuite.TestSuiteChromosome;

public class MinimizeAverageLengthSecondaryObjective
extends SecondaryObjective<TestSuiteChromosome> {
    private static final long serialVersionUID = -6272641645062817112L;

    private double getAverageLength(TestSuiteChromosome chromosome) {
        return (double)chromosome.totalLengthOfTestCases() / (double)chromosome.size();
    }

    @Override
    public int compareChromosomes(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        return (int)Math.signum(this.getAverageLength(chromosome1) - this.getAverageLength(chromosome2));
    }

    @Override
    public int compareGenerations(TestSuiteChromosome parent1, TestSuiteChromosome parent2, TestSuiteChromosome child1, TestSuiteChromosome child2) {
        return (int)Math.signum(Math.min(this.getAverageLength(parent1), this.getAverageLength(parent2)) - Math.min(this.getAverageLength(child1), this.getAverageLength(child2)));
    }
}

