/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.evosuite.Properties;
import org.evosuite.utils.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Randomness
implements Serializable {
    private static final long serialVersionUID = -5934455398558935937L;
    private static final Logger logger = LoggerFactory.getLogger(Randomness.class);
    private static long seed = 0L;
    private static Random random = null;
    private static Randomness instance = new Randomness();

    private Randomness() {
        Long seed_parameter = Properties.RANDOM_SEED;
        if (seed_parameter != null) {
            seed = seed_parameter;
            logger.info("Random seed: {}", (Object)seed);
        } else {
            seed = System.currentTimeMillis();
            logger.info("No seed given. Using {}.", (Object)seed);
        }
        random = new MersenneTwister(seed);
    }

    public static Randomness getInstance() {
        if (instance == null) {
            instance = new Randomness();
        }
        return instance;
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }

    public static int nextInt(int max) {
        return random.nextInt(max);
    }

    public static double nextGaussian() {
        return random.nextGaussian();
    }

    public static int nextInt(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static int nextInt() {
        return random.nextInt();
    }

    public static char nextChar() {
        return (char)Randomness.nextInt(32, 128);
    }

    public static short nextShort() {
        return (short)(random.nextInt(65534) - Short.MAX_VALUE);
    }

    public static long nextLong() {
        return random.nextLong();
    }

    public static byte nextByte() {
        return (byte)(random.nextInt(256) - 128);
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static double nextDouble(double min, double max) {
        return min + random.nextDouble() * (max - min);
    }

    public static float nextFloat() {
        return random.nextFloat();
    }

    public static void setSeed(long seed) {
        Randomness.seed = seed;
        random.setSeed(seed);
    }

    public static long getSeed() {
        return seed;
    }

    public static <T> T choice(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        int position = random.nextInt(list.size());
        return list.get(position);
    }

    public static <T> T choice(Collection<T> set) {
        if (set.isEmpty()) {
            return null;
        }
        int position = random.nextInt(set.size());
        return (T)set.toArray()[position];
    }

    public static <T> T choice(T ... elements) {
        if (elements.length == 0) {
            return null;
        }
        int position = random.nextInt(elements.length);
        return elements[position];
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, random);
    }

    public static String nextString(int length) {
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = Randomness.nextChar();
        }
        return new String(characters);
    }
}

