/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class RegexDistanceUtils {
    private static Map<String, List<State>> regexStateCache = new HashMap<String, List<State>>();
    private static Map<String, Automaton> regexAutomatonCache = new HashMap<String, Automaton>();

    public static Automaton getRegexAutomaton(String regex) {
        if (!regexAutomatonCache.containsKey(regex)) {
            RegexDistanceUtils.cacheRegex(regex);
        }
        return regexAutomatonCache.get(regex);
    }

    public static String getRegexInstance(String regex) {
        if (!regexAutomatonCache.containsKey(regex)) {
            RegexDistanceUtils.cacheRegex(regex);
        }
        Automaton automaton = regexAutomatonCache.get(regex);
        return automaton.getShortestExample(true);
    }

    public static String getNonMatchingRegexInstance(String regex) {
        if (!regexAutomatonCache.containsKey(regex)) {
            RegexDistanceUtils.cacheRegex(regex);
        }
        Automaton automaton = regexAutomatonCache.get(regex);
        return automaton.getShortestExample(false);
    }

    private static double normalize(double x) {
        return x / (x + 1.0);
    }

    public static String expandRegex(String regex) {
        String newRegex = regex.replaceAll("\\\\d", "[0-9]");
        newRegex = newRegex.replaceAll("\\\\D", "[^0-9]");
        newRegex = newRegex.replaceAll("\\\\s", "[ \\t\\n\\f\\r]");
        newRegex = newRegex.replaceAll("\\\\S", "[^ \\t\\n\\f\\r]");
        newRegex = newRegex.replaceAll("\\\\w", "[a-zA-Z_0-9]");
        if ((newRegex = newRegex.replaceAll("\\\\W", "[^a-zA-Z_0-9]")).startsWith("^")) {
            newRegex = newRegex.substring(1);
        }
        if (newRegex.endsWith("$")) {
            newRegex = newRegex.substring(0, newRegex.length() - 1);
        }
        newRegex = RegexDistanceUtils.removeFlagExpressions(newRegex);
        newRegex = RegexDistanceUtils.removeReluctantOperators(newRegex);
        return newRegex;
    }

    protected static String removeFlagExpressions(String regex) {
        regex = regex.replaceAll("\\(\\?i\\)", "");
        regex = regex.replaceAll("\\(\\?d\\)", "");
        regex = regex.replaceAll("\\(\\?x\\)", "");
        regex = regex.replaceAll("\\(\\?m\\)", "");
        regex = regex.replaceAll("\\(\\?s\\)", "");
        regex = regex.replaceAll("\\(\\?u\\)", "");
        return regex;
    }

    protected static String removeReluctantOperators(String regex) {
        regex = regex.replaceAll("\\+\\?", "\\+");
        regex = regex.replaceAll("\\*\\?", "\\*");
        regex = regex.replaceAll("\\?\\?", "\\?");
        return regex;
    }

    private static void ensureState(Map<Integer, Map<State, Set<GraphTransition>>> transitions, State state, int numRows) {
        for (int row = 0; row <= numRows; ++row) {
            if (!transitions.containsKey(row)) {
                transitions.put(row, new HashMap());
            }
            if (transitions.get(row).containsKey(state)) continue;
            transitions.get(row).put(state, new HashSet());
        }
    }

    private static void cacheRegex(String regex) {
        String r = RegexDistanceUtils.expandRegex(regex);
        Automaton automaton = new RegExp(r, 0).toAutomaton();
        automaton.expandSingleton();
        DefaultDirectedGraph regexGraph = new DefaultDirectedGraph(DefaultEdge.class);
        HashSet<State> visitedStates = new HashSet<State>();
        LinkedList<State> states = new LinkedList<State>();
        State initialState = automaton.getInitialState();
        states.add(initialState);
        while (!states.isEmpty()) {
            State currentState = (State)states.poll();
            if (visitedStates.contains(currentState)) continue;
            if (!regexGraph.containsVertex((Object)currentState)) {
                regexGraph.addVertex((Object)currentState);
            }
            for (Transition t : currentState.getTransitions()) {
                if (t.getDest().equals((Object)currentState)) continue;
                regexGraph.addVertex((Object)t.getDest());
                regexGraph.addEdge((Object)currentState, (Object)t.getDest());
                states.add(t.getDest());
                CycleDetector det = new CycleDetector((DirectedGraph)regexGraph);
                if (!det.detectCycles()) continue;
                regexGraph.removeEdge((Object)currentState, (Object)t.getDest());
            }
            visitedStates.add(currentState);
        }
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)regexGraph);
        ArrayList<Object> topologicalOrder = new ArrayList<Object>();
        while (iterator.hasNext()) {
            topologicalOrder.add(iterator.next());
        }
        regexStateCache.put(regex, topologicalOrder);
        regexAutomatonCache.put(regex, automaton);
    }

    public static int getStandardDistance(String arg, String regex) {
        if (!RegexDistanceUtils.isSupportedRegex(regex)) {
            return RegexDistanceUtils.getDefaultDistance(arg, regex);
        }
        RegexGraph graph = new RegexGraph(arg, regex);
        CostMatrix matrix = new CostMatrix();
        return matrix.calculateStandardCost(graph);
    }

    private static int getDefaultDistance(String arg, String regex) {
        Pattern p = Pattern.compile(regex);
        if (p.matcher(arg).matches()) {
            return 0;
        }
        return 1;
    }

    private static boolean isSupportedRegex(String regex) {
        return !regex.contains("\\b");
    }

    public static double getDistanceTailoredForStringAVM(String arg, String regex) {
        RegexGraph graph = new RegexGraph(arg, regex);
        CostMatrix matrix = new CostMatrix();
        return matrix.calculateCostForStringAVM(graph);
    }

    protected static Automaton getAndCacheAutomaton(String regex) {
        if (!regexAutomatonCache.containsKey(regex)) {
            RegexDistanceUtils.cacheRegex(regex);
        }
        Automaton automaton = regexAutomatonCache.get(regex);
        return automaton;
    }

    private static class CostMatrix {
        private final int DEL = 0;
        private final int REP = 1;
        private final int INS = 2;

        public int calculateStandardCost(RegexGraph graph) {
            int ROWS = graph.getNumberOfRows();
            int COLUMNS = graph.getNumberOfColumns();
            double[][] matrix = new double[ROWS][COLUMNS];
            boolean FIRST_ROW = false;
            matrix[0][0] = 0.0;
            for (int col = 1; col < graph.getNumberOfColumns(); ++col) {
                double min = Double.MAX_VALUE;
                for (GraphTransition t : graph.getIncomingTransitions(0, col)) {
                    int otherCol = graph.getColumn(t.fromState);
                    if (col == otherCol) continue;
                    double otherCost = matrix[0][otherCol];
                    min = Math.min(min, this.getSubPathCost(otherCost, Math.ceil(t.cost)));
                }
                matrix[0][col] = min;
            }
            for (int i = 1; i < ROWS; ++i) {
                for (int col = 0; col < COLUMNS; ++col) {
                    matrix[i][col] = Double.MAX_VALUE;
                    for (GraphTransition t : graph.getIncomingTransitions(i, col)) {
                        int otherCol = graph.getColumn(t.fromState);
                        int otherRow = t.fromRow;
                        if (!t.type.equals((Object)GraphTransition.TransitionType.PHANTOM)) {
                            matrix[i][col] = Math.min(matrix[i][col], this.getSubPathCost(matrix[otherRow][otherCol], Math.ceil(t.cost)));
                            continue;
                        }
                        matrix[i][col] = Math.min(matrix[i][col], matrix[otherRow][otherCol]);
                    }
                }
            }
            double min = matrix[ROWS - 1][COLUMNS - 1];
            return (int)Math.round(min);
        }

        public double calculateCostForStringAVM(RegexGraph graph) {
            int ROWS = graph.getNumberOfRows();
            int COLUMNS = graph.getNumberOfColumns();
            double[][][] matrix = new double[ROWS][COLUMNS][3];
            this.calculateInsertionCostOnFirstRow(graph, matrix);
            for (int i = 1; i < ROWS; ++i) {
                for (int col = 0; col < COLUMNS; ++col) {
                    matrix[i][col][0] = Double.MAX_VALUE;
                    matrix[i][col][1] = Double.MAX_VALUE;
                    matrix[i][col][2] = Double.MAX_VALUE;
                    Object object = graph.getIncomingTransitions(i, col).iterator();
                    while (object.hasNext()) {
                        GraphTransition t = (GraphTransition)object.next();
                        int otherCol = graph.getColumn(t.fromState);
                        int otherRow = t.fromRow;
                        if (t.type.equals((Object)GraphTransition.TransitionType.INSERTION)) {
                            assert (otherRow == i);
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][2], t.cost));
                            continue;
                        }
                        if (t.type.equals((Object)GraphTransition.TransitionType.REPLACEMENT)) {
                            matrix[i][col][1] = Math.min(matrix[i][col][1], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            matrix[i][col][1] = Math.min(matrix[i][col][1], this.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                            continue;
                        }
                        if (t.type.equals((Object)GraphTransition.TransitionType.DELETION)) {
                            matrix[i][col][0] = Math.min(matrix[i][col][0], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            matrix[i][col][1] = Math.min(matrix[i][col][1], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            matrix[i][col][2] = Math.min(matrix[i][col][2], this.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                            continue;
                        }
                        if (!t.type.equals((Object)GraphTransition.TransitionType.PHANTOM)) continue;
                        assert (t.cost == 0.0);
                        matrix[i][col][0] = Math.min(matrix[i][col][0], matrix[otherRow][otherCol][0]);
                        matrix[i][col][1] = Math.min(matrix[i][col][1], matrix[otherRow][otherCol][1]);
                        matrix[i][col][2] = Math.min(matrix[i][col][2], matrix[otherRow][otherCol][2]);
                    }
                }
            }
            double min = Double.MAX_VALUE;
            for (double value : matrix[ROWS - 1][COLUMNS - 1]) {
                if (!(value < min)) continue;
                min = value;
            }
            return min;
        }

        private double getSubPathCost(double previousStateCost, double transitionCost) throws IllegalArgumentException {
            if (previousStateCost < 0.0) {
                throw new IllegalArgumentException("previousStateCost cannot be negative: " + previousStateCost);
            }
            if (transitionCost < 0.0) {
                throw new IllegalArgumentException("transitionCost cannot be negative: " + transitionCost);
            }
            if (previousStateCost == Double.MAX_VALUE || transitionCost == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            double sum = previousStateCost + transitionCost;
            if (sum < previousStateCost || sum < transitionCost) {
                return Double.MAX_VALUE;
            }
            return sum;
        }

        private void calculateInsertionCostOnFirstRow(RegexGraph graph, double[][][] matrix) {
            boolean FIRST_ROW = false;
            matrix[0][0][0] = 0.0;
            matrix[0][0][1] = 0.0;
            matrix[0][0][2] = 0.0;
            for (int col = 1; col < graph.getNumberOfColumns(); ++col) {
                double min = Double.MAX_VALUE;
                for (GraphTransition t : graph.getIncomingTransitions(0, col)) {
                    assert (t.type.equals((Object)GraphTransition.TransitionType.INSERTION) || t.type.equals((Object)GraphTransition.TransitionType.PHANTOM));
                    assert (t.fromRow == 0);
                    int otherCol = graph.getColumn(t.fromState);
                    if (col == otherCol) continue;
                    double otherCost = matrix[0][otherCol][2];
                    min = Math.min(min, this.getSubPathCost(otherCost, t.cost));
                }
                matrix[0][col][0] = Double.MAX_VALUE;
                matrix[0][col][1] = Double.MAX_VALUE;
                matrix[0][col][2] = min;
            }
        }
    }

    private static class RegexGraph {
        private Map<Integer, Map<State, Set<GraphTransition>>> transitions;
        private Map<Integer, State> intToStateMap;
        private Map<State, Integer> stateToIntMap;

        public RegexGraph(String arg, String regex) {
            this.transitions = this.createGraph(arg, regex);
        }

        public int getNumberOfRows() {
            return this.transitions.keySet().size();
        }

        public int getNumberOfColumns() {
            return this.stateToIntMap.size();
        }

        public Set<GraphTransition> getIncomingTransitions(int row, int column) {
            State state = this.intToStateMap.get(column);
            return this.transitions.get(row).get(state);
        }

        public int getColumn(State state) {
            return this.stateToIntMap.get(state);
        }

        private Map<Integer, Map<State, Set<GraphTransition>>> createGraph(String arg, String regex) {
            Automaton automaton = RegexDistanceUtils.getAndCacheAutomaton(regex);
            int NUM_CHARS = arg.length();
            List topologicalOrder = (List)regexStateCache.get(regex);
            HashMap<Integer, Map<State, Set<GraphTransition>>> transitions = new HashMap<Integer, Map<State, Set<GraphTransition>>>();
            this.intToStateMap = new HashMap<Integer, State>();
            this.stateToIntMap = new HashMap<State, Integer>();
            int numState = 0;
            for (State currentState : topologicalOrder) {
                this.stateToIntMap.put(currentState, numState);
                this.intToStateMap.put(numState, currentState);
                ++numState;
                for (Transition t : currentState.getTransitions()) {
                    int row;
                    State destination = t.getDest();
                    RegexDistanceUtils.ensureState(transitions, destination, NUM_CHARS);
                    for (row = 0; row <= NUM_CHARS; ++row) {
                        ((Set)((Map)transitions.get(row)).get(destination)).add(new GraphTransition(1.0, row, currentState, GraphTransition.TransitionType.INSERTION));
                    }
                    for (row = 0; row < NUM_CHARS; ++row) {
                        double cost = 0.0;
                        if (arg.charAt(row) < t.getMin() || arg.charAt(row) > t.getMax()) {
                            int distMin = Math.abs(arg.charAt(row) - t.getMin());
                            int distMax = Math.abs(arg.charAt(row) - t.getMax());
                            cost = RegexDistanceUtils.normalize(Math.min(distMin, distMax));
                        }
                        ((Set)((Map)transitions.get(row + 1)).get(destination)).add(new GraphTransition(cost, row, currentState, GraphTransition.TransitionType.REPLACEMENT));
                    }
                }
                RegexDistanceUtils.ensureState(transitions, currentState, NUM_CHARS);
                for (int row = 0; row < NUM_CHARS; ++row) {
                    ((Set)((Map)transitions.get(row + 1)).get(currentState)).add(new GraphTransition(1.0, row, currentState, GraphTransition.TransitionType.DELETION));
                }
            }
            State finalState = new State();
            RegexDistanceUtils.ensureState(transitions, finalState, NUM_CHARS);
            for (State s : automaton.getStates()) {
                if (!s.isAccept()) continue;
                ((Set)((Map)transitions.get(NUM_CHARS)).get(finalState)).add(new GraphTransition(0.0, NUM_CHARS, s, GraphTransition.TransitionType.PHANTOM));
            }
            this.intToStateMap.put(numState, finalState);
            this.stateToIntMap.put(finalState, numState);
            return transitions;
        }
    }

    private static class GraphTransition {
        public final double cost;
        public final int fromRow;
        public final State fromState;
        public final TransitionType type;

        public GraphTransition(double cost, int fromRow, State fromState, TransitionType type) {
            this.cost = cost;
            this.fromRow = fromRow;
            this.fromState = fromState;
            this.type = type;
        }

        public static enum TransitionType {
            INSERTION,
            DELETION,
            REPLACEMENT,
            PHANTOM;

        }
    }
}

