/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;

public class GenericMethod
extends GenericAccessibleObject<GenericMethod> {
    private static final long serialVersionUID = 6091851133071150237L;
    private transient Method method;

    public GenericMethod(Method method, GenericClass type) {
        super(new GenericClass(type));
        this.method = method;
        Inputs.checkNull((Object[])new Object[]{method, type});
    }

    public GenericMethod(Method method, Class<?> type) {
        super(new GenericClass(type));
        this.method = method;
        Inputs.checkNull((Object[])new Object[]{method, type});
    }

    public GenericMethod(Method method, Type type) {
        super(new GenericClass(type));
        this.method = method;
        Inputs.checkNull((Object[])new Object[]{method, type});
    }

    @Override
    public GenericMethod copyWithNewOwner(GenericClass newOwner) {
        GenericMethod copy = new GenericMethod(this.method, newOwner);
        this.copyTypeVariables(copy);
        return copy;
    }

    @Override
    public GenericMethod copyWithOwnerFromReturnType(GenericClass returnType) throws ConstructionFailedException {
        GenericClass newOwner = this.getOwnerClass().getGenericInstantiation(returnType.getTypeVariableMap());
        GenericMethod copy = new GenericMethod(this.method, newOwner);
        this.copyTypeVariables(copy);
        return copy;
    }

    @Override
    public GenericMethod copy() {
        GenericMethod copy = new GenericMethod(this.method, new GenericClass(this.owner));
        this.copyTypeVariables(copy);
        return copy;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.method;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public Type[] getParameterTypes() {
        return this.getExactParameterTypes(this.method, this.owner.getType());
    }

    public List<GenericClass> getParameterClasses() {
        ArrayList<GenericClass> parameters = new ArrayList<GenericClass>();
        if (logger.isDebugEnabled()) {
            logger.debug("Parameter types: " + Arrays.asList(this.method.getGenericParameterTypes()));
        }
        for (Type parameterType : this.getParameterTypes()) {
            logger.debug("Adding parameter: {}", (Object)parameterType);
            parameters.add(new GenericClass(parameterType));
        }
        return parameters;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public Class<?>[] getRawParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Type getGeneratedType() {
        return this.getReturnType();
    }

    public Type getReturnType() {
        Type returnType = this.getExactReturnType(this.method, this.owner.getType());
        if (returnType == null) {
            LoggingUtils.getEvoLogger().info("Exact return type is null for {} with owner {}", (Object)this.method, (Object)this.owner);
            for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                LoggingUtils.getEvoLogger().info(elem.toString());
            }
            assert (false);
            returnType = this.method.getGenericReturnType();
        }
        return returnType;
    }

    @Override
    public Type getGenericGeneratedType() {
        return this.method.getGenericReturnType();
    }

    @Override
    public Class<?> getRawGeneratedType() {
        return this.method.getReturnType();
    }

    protected Type getExactReturnType(Method m, Type type) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{m, type});
        Type returnType = m.getGenericReturnType();
        Type exactDeclaringType = GenericTypeReflector.getExactSuperType((Type)GenericTypeReflector.capture((Type)type), m.getDeclaringClass());
        if (exactDeclaringType == null) {
            logger.info("The method " + m + " is not a member of type " + type + " - declared in " + m.getDeclaringClass());
            return m.getReturnType();
        }
        return this.mapTypeParameters(returnType, exactDeclaringType);
    }

    public Type[] getExactParameterTypes(Method m, Type type) {
        Type[] parameterTypes = m.getGenericParameterTypes();
        Type exactDeclaringType = GenericTypeReflector.getExactSuperType((Type)GenericTypeReflector.capture((Type)type), m.getDeclaringClass());
        if (exactDeclaringType == null) {
            logger.info("The method " + m + " is not a member of type " + type + " - declared in " + m.getDeclaringClass());
            return m.getParameterTypes();
        }
        Type[] result = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result[i] = this.mapTypeParameters(parameterTypes[i], exactDeclaringType);
        }
        return result;
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        return this.method.getTypeParameters();
    }

    @Override
    public boolean isAccessible() {
        return TestUsageChecker.canUse(this.method);
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isOverloaded() {
        String methodName = this.getName();
        Class<?> declaringClass = this.method.getDeclaringClass();
        try {
            for (Method otherMethod : declaringClass.getMethods()) {
                if (otherMethod.equals(this.method) || !otherMethod.getName().equals(methodName)) continue;
                return true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    public boolean isOverloaded(List<VariableReference> parameters) {
        String methodName = this.getName();
        Class<?> declaringClass = this.method.getDeclaringClass();
        Object[] parameterTypes = this.method.getParameterTypes();
        boolean isExact = true;
        Class[] parameterClasses = new Class[parameters.size()];
        for (int num = 0; num < parameters.size(); ++num) {
            VariableReference parameter = parameters.get(num);
            parameterClasses[num] = parameter.getVariableClass();
            if (parameterClasses[num].equals(parameterTypes[num])) continue;
            isExact = false;
            break;
        }
        if (isExact) {
            return false;
        }
        try {
            for (Method otherMethod : declaringClass.getMethods()) {
                if (otherMethod.equals(this.method) || !otherMethod.getName().equals(methodName) || Arrays.equals(otherMethod.getParameterTypes(), parameterTypes)) continue;
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getNumParameters() {
        return this.method.getGenericParameterTypes().length;
    }

    public boolean isGenericMethod() {
        return this.getNumParameters() > 0;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public String getNameWithDescriptor() {
        return this.method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)this.method);
    }

    public String getDescriptor() {
        return org.objectweb.asm.Type.getMethodDescriptor((Method)this.method);
    }

    @Override
    public String toString() {
        return this.method.toGenericString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.method.getDeclaringClass().getName());
        oos.writeObject(this.method.getName());
        oos.writeObject(org.objectweb.asm.Type.getMethodDescriptor((Method)this.method));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Class<?> methodClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        String methodName = (String)ois.readObject();
        String methodDesc = (String)ois.readObject();
        for (Method method : methodClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !org.objectweb.asm.Type.getMethodDescriptor((Method)method).equals(methodDesc)) continue;
            this.method = method;
            return;
        }
        if (this.method == null) {
            throw new IllegalStateException("Unknown method for " + methodName + " in class " + methodClass.getCanonicalName());
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
        try {
            Class<?> oldClass = this.method.getDeclaringClass();
            Class<?> newClass = loader.loadClass(oldClass.getName());
            for (Method newMethod : TestClusterUtils.getMethods(newClass)) {
                Class<?>[] newParameters;
                if (!newMethod.getName().equals(this.method.getName())) continue;
                boolean equals = true;
                Class<?>[] oldParameters = this.method.getParameterTypes();
                if (oldParameters.length != (newParameters = newMethod.getParameterTypes()).length || !newMethod.getDeclaringClass().getName().equals(this.method.getDeclaringClass().getName()) || !newMethod.getReturnType().getName().equals(this.method.getReturnType().getName())) continue;
                for (int i = 0; i < newParameters.length; ++i) {
                    if (oldParameters[i].getName().equals(newParameters[i].getName())) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                this.method = newMethod;
                this.method.setAccessible(true);
                return;
            }
            LoggingUtils.getEvoLogger().info("Method not found - keeping old class loader ");
        }
        catch (ClassNotFoundException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", (Throwable)e);
        }
        catch (SecurityException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", (Throwable)e);
        }
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.method.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.method.getModifiers());
    }

    @Override
    public boolean isDefault() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMethod other = (GenericMethod)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }
}

