/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.evosuite.shaded.org.apache.commons.lang3.ObjectUtils;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;

public class CSVParser
implements ICSVParser {
    private static final int BEGINING_OF_LINE = 3;
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;
    private final boolean ignoreQuotations;
    private final CSVReaderNullFieldIndicator nullFieldIndicator;
    private String pending;
    private int tokensOnLastCompleteLine = -1;
    private boolean inField = false;
    private final Locale errorLocale;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    @Deprecated
    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    @Deprecated
    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations, DEFAULT_NULL_FIELD_INDICATOR);
    }

    @Deprecated
    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations, nullFieldIndicator, Locale.getDefault());
    }

    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations, CSVReaderNullFieldIndicator nullFieldIndicator, Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("special.characters.must.differ"));
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("define.separator"));
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isStrictQuotes() {
        return this.strictQuotes;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.ignoreLeadingWhiteSpace;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values) {
        StringBuilder builder = new StringBuilder(1024);
        for (int i = 0; i < values.length; ++i) {
            builder.append(this.convertToCsvValue(values[i]));
            if (i >= values.length - 1) continue;
            builder.append(this.getSeparator());
        }
        return builder.toString();
    }

    private String convertToCsvValue(String value) {
        String testValue = value == null && !this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.NEITHER) ? "" : value;
        StringBuilder builder = new StringBuilder(testValue == null ? 16 : testValue.length() * 2);
        boolean containsQuoteChar = testValue != null && testValue.contains(Character.toString(this.getQuotechar()));
        boolean containsEscapeChar = testValue != null && testValue.contains(Character.toString(this.getEscape()));
        boolean containsSeparatorChar = testValue != null && testValue.contains(Character.toString(this.getSeparator()));
        boolean surroundWithQuotes = this.isSurroundWithQuotes(value, containsSeparatorChar);
        String convertedString = !containsQuoteChar ? testValue : testValue.replaceAll(Character.toString(this.getQuotechar()), Character.toString(this.getQuotechar()) + Character.toString(this.getQuotechar()));
        String string = convertedString = !containsEscapeChar ? convertedString : convertedString.replace(Character.toString(this.getEscape()), Character.toString(this.getEscape()) + Character.toString(this.getEscape()));
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        builder.append(convertedString);
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        return builder.toString();
    }

    private boolean isSurroundWithQuotes(String value, boolean containsQuoteChar) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        return containsQuoteChar || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending == null) return null;
            String s = this.pending;
            this.pending = null;
            return new String[]{s};
        }
        ArrayList<String> tokensOnThisLine = this.tokensOnLastCompleteLine <= 0 ? new ArrayList<String>() : new ArrayList(this.tokensOnLastCompleteLine);
        StringFragmentCopier sfc = new StringFragmentCopier(nextLine);
        boolean inQuotes = false;
        boolean fromQuotedField = false;
        if (this.pending != null) {
            sfc.append(this.pending);
            this.pending = null;
            boolean bl = inQuotes = !this.ignoreQuotations;
        }
        while (!sfc.isEmptyInput()) {
            char c = sfc.takeInput();
            if (c == this.escape) {
                if (!this.isNextCharacterEscapable(nextLine, this.inQuotes(inQuotes), sfc.i - 1)) continue;
                sfc.takeInput();
                sfc.appendPrev();
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, this.inQuotes(inQuotes), sfc.i - 1)) {
                    sfc.takeInput();
                    sfc.appendPrev();
                } else {
                    int i;
                    boolean bl = inQuotes = !inQuotes;
                    if (sfc.isEmptyOutput()) {
                        fromQuotedField = true;
                    }
                    if (!this.strictQuotes && (i = sfc.i) > 3 && nextLine.charAt(i - 2) != this.separator && nextLine.length() > i && nextLine.charAt(i) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && !sfc.isEmptyOutput() && StringUtils.isWhitespace(sfc.peekOutput())) {
                            sfc.clearOutput();
                        } else {
                            sfc.appendPrev();
                        }
                    }
                }
                this.inField = !this.inField;
                continue;
            }
            if (c == this.separator && (!inQuotes || this.ignoreQuotations)) {
                tokensOnThisLine.add(this.convertEmptyToNullIfNeeded(sfc.takeOutput(), fromQuotedField));
                fromQuotedField = false;
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && (!inQuotes || this.ignoreQuotations)) continue;
            sfc.appendPrev();
            this.inField = true;
            fromQuotedField = true;
        }
        if (inQuotes && !this.ignoreQuotations) {
            if (!multi) throw new IOException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("unterminated.quote"), sfc.peekOutput()));
            sfc.append('\n');
            this.pending = sfc.peekOutput();
        } else {
            this.inField = false;
            tokensOnThisLine.add(this.convertEmptyToNullIfNeeded(sfc.takeOutput(), fromQuotedField));
        }
        this.tokensOnLastCompleteLine = tokensOnThisLine.size();
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private String convertEmptyToNullIfNeeded(String s, boolean fromQuotedField) {
        if (s.isEmpty() && this.shouldConvertEmptyToNull(fromQuotedField)) {
            return null;
        }
        return s;
    }

    private boolean shouldConvertEmptyToNull(boolean fromQuotedField) {
        switch (this.nullFieldIndicator) {
            case BOTH: {
                return true;
            }
            case EMPTY_SEPARATORS: {
                return !fromQuotedField;
            }
            case EMPTY_QUOTES: {
                return fromQuotedField;
            }
        }
        return false;
    }

    private boolean inQuotes(boolean inQuotes) {
        return inQuotes && !this.ignoreQuotations || this.inField;
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterQuoteCharacter(nextLine.charAt(i + 1));
    }

    private boolean isCharacterQuoteCharacter(char c) {
        return c == this.quotechar;
    }

    private boolean isCharacterEscapeCharacter(char c) {
        return c == this.escape;
    }

    private boolean isCharacterEscapable(char c) {
        return this.isCharacterQuoteCharacter(c) || this.isCharacterEscapeCharacter(c);
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterEscapable(nextLine.charAt(i + 1));
    }

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString(this.pending);
    }

    private static class StringFragmentCopier {
        private final String input;
        private int i = 0;
        private StringBuilder sb;
        private int pendingSubstrFrom = 0;
        private int pendingSubstrTo = 0;

        public StringFragmentCopier(String input) {
            this.input = input;
        }

        public boolean isEmptyInput() {
            return this.i >= this.input.length();
        }

        public char takeInput() {
            return this.input.charAt(this.i++);
        }

        private StringBuilder materializeBuilder() {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.input.length() + 128);
            }
            if (this.pendingSubstrFrom < this.pendingSubstrTo) {
                this.sb.append(this.input, this.pendingSubstrFrom, this.pendingSubstrTo);
                this.pendingSubstrFrom = this.pendingSubstrTo = this.i;
            }
            return this.sb;
        }

        public void append(String pending) {
            this.materializeBuilder().append(pending);
        }

        public void append(char pending) {
            this.materializeBuilder().append(pending);
        }

        public void appendPrev() {
            if (this.pendingSubstrTo == this.pendingSubstrFrom) {
                this.pendingSubstrFrom = this.i - 1;
                this.pendingSubstrTo = this.i;
            } else if (this.pendingSubstrTo == this.i - 1) {
                ++this.pendingSubstrTo;
            } else {
                this.materializeBuilder().append(this.input.charAt(this.i - 1));
            }
        }

        public boolean isEmptyOutput() {
            return this.pendingSubstrFrom >= this.pendingSubstrTo && (this.sb == null || this.sb.length() == 0);
        }

        public void clearOutput() {
            if (this.sb != null) {
                this.sb.setLength(0);
            }
            this.pendingSubstrFrom = this.pendingSubstrTo = this.i;
        }

        public String peekOutput() {
            if (this.sb == null || this.sb.length() == 0) {
                return this.input.substring(this.pendingSubstrFrom, this.pendingSubstrTo);
            }
            return this.materializeBuilder().toString();
        }

        public String takeOutput() {
            String result = this.peekOutput();
            this.clearOutput();
            return result;
        }
    }
}

