/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.FieldUtils;

public final class opencsvUtils {
    private opencsvUtils() {
    }

    public static <T> MappingStrategy<T> determineMappingStrategy(Class type, Locale errorLocale) {
        HeaderColumnNameMappingStrategy mappingStrategy;
        Field[] fields = FieldUtils.getAllFields(type);
        boolean positionAnnotationsPresent = false;
        for (Field field : fields) {
            if (field.isAnnotationPresent(CsvBindByPosition.class) || field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                positionAnnotationsPresent = true;
                break;
            }
            if (positionAnnotationsPresent) break;
        }
        if (positionAnnotationsPresent) {
            ColumnPositionMappingStrategy ms = new ColumnPositionMappingStrategy();
            ms.setErrorLocale(errorLocale);
            ms.setType(type);
            mappingStrategy = ms;
        } else {
            HeaderColumnNameMappingStrategy ms = new HeaderColumnNameMappingStrategy();
            ms.setErrorLocale(errorLocale);
            ms.setType(type);
            if (!ms.isAnnotationDriven()) {
                TreeSet<String> sortedFields = new TreeSet<String>();
                for (Field f : fields) {
                    if (f.isSynthetic()) continue;
                    sortedFields.add(f.getName());
                }
                String header = StringUtils.join(sortedFields, ',').concat("\n");
                try {
                    CSVReader csvr = new CSVReaderBuilder(new StringReader(header)).withErrorLocale(errorLocale).build();
                    ms.captureHeader(csvr);
                    ms.findDescriptor(0);
                }
                catch (IOException iOException) {
                }
                catch (CsvRequiredFieldEmptyException csvRequiredFieldEmptyException) {
                    // empty catch block
                }
            }
            mappingStrategy = ms;
        }
        return mappingStrategy;
    }

    public static <E> void queueRefuseToAcceptDefeat(BlockingQueue<E> queue, E object) {
        boolean interrupted = true;
        while (interrupted) {
            try {
                queue.put(object);
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

