/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.ContainsAssertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.variable.VariableReference;

public class ContainsTraceEntry
implements OutputTraceEntry {
    protected VariableReference containerVar;
    protected Map<VariableReference, Boolean> containsMap = new HashMap<VariableReference, Boolean>();
    private final Map<Integer, VariableReference> containsMapIntVar = new HashMap<Integer, VariableReference>();

    public ContainsTraceEntry(VariableReference containerVar) {
        this.containerVar = containerVar;
    }

    public void addEntry(VariableReference other, boolean value) {
        this.containsMap.put(other, value);
        this.containsMapIntVar.put(other.getStPosition(), other);
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof ContainsTraceEntry) {
            ContainsTraceEntry otherEntry = (ContainsTraceEntry)other;
            if (!this.containerVar.equals(otherEntry.containerVar)) {
                return false;
            }
            for (VariableReference otherVar : this.containsMap.keySet()) {
                if (!otherEntry.containsMap.containsKey(otherVar) || otherEntry.containsMap.get(otherVar).equals(this.containsMap.get(otherVar))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof ContainsTraceEntry) {
            ContainsTraceEntry otherEntry = (ContainsTraceEntry)other;
            for (Integer otherVar : this.containsMapIntVar.keySet()) {
                if (!otherEntry.containsMapIntVar.containsKey(otherVar) || otherVar == null || otherEntry.containsMap.get(otherEntry.containsMapIntVar.get(otherVar)).equals(this.containsMap.get(this.containsMapIntVar.get(otherVar)))) continue;
                ContainsAssertion assertion = new ContainsAssertion();
                assertion.source = this.containerVar;
                assertion.containedVariable = this.containsMapIntVar.get(otherVar);
                assertion.value = this.containsMap.get(this.containsMapIntVar.get(otherVar));
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (VariableReference otherVar : this.containsMap.keySet()) {
            if (otherVar == null) continue;
            ContainsAssertion assertion = new ContainsAssertion();
            assertion.source = this.containerVar;
            assertion.containedVariable = otherVar;
            assertion.value = this.containsMap.get(otherVar);
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof ContainsAssertion) {
            ContainsAssertion ass = (ContainsAssertion)assertion;
            if (ass.source.equals(this.containerVar) && this.containsMap.containsKey(ass.containedVariable)) {
                return !this.containsMap.get(ass.containedVariable).equals(ass.value);
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        ContainsTraceEntry copy = new ContainsTraceEntry(this.containerVar);
        copy.containsMap.putAll(this.containsMap);
        copy.containsMapIntVar.putAll(this.containsMapIntVar);
        return copy;
    }
}

