/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.ContainsTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;

public class ContainsTraceObserver
extends AssertionTraceObserver<ContainsTraceEntry> {
    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        try {
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (statement instanceof AssignmentStatement) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (!(object instanceof Collection)) {
                return;
            }
            Collection collectionObject = (Collection)object;
            List<GenericClass> parameterClasses = var.getGenericClass().getParameterClasses();
            if (parameterClasses.size() != 1) {
                return;
            }
            Type parameterType = parameterClasses.get(0).getType();
            ContainsTraceEntry entry = new ContainsTraceEntry(var);
            int position = statement.getPosition();
            LinkedHashSet<VariableReference> otherVariables = new LinkedHashSet<VariableReference>();
            otherVariables.addAll(scope.getElements(parameterType));
            for (int i = 0; i <= statement.getPosition(); ++i) {
                for (VariableReference candidateVar : currentTest.getStatement(i).getVariableReferences()) {
                    if (!(candidateVar instanceof ConstantValue) || !candidateVar.isAssignableTo(parameterType)) continue;
                    otherVariables.add(candidateVar);
                }
            }
            for (VariableReference other : otherVariables) {
                Statement otherStatement;
                int otherPos;
                Object otherObject = other instanceof ConstantValue ? ((ConstantValue)other).getValue() : other.getObject(scope);
                if (otherObject == null || (otherPos = other.getStPosition()) > position || (otherStatement = currentTest.getStatement(otherPos)) instanceof MethodStatement && ((MethodStatement)otherStatement).getMethodName().equals("hashCode")) continue;
                try {
                    logger.debug("Checking whether {} contains {} is: {}", var, other, collectionObject.contains(otherObject));
                    entry.addEntry(other, collectionObject.contains(otherObject));
                }
                catch (Throwable t) {
                    logger.debug("Exception during equals: " + t);
                }
                if (!(object instanceof Comparable)) continue;
            }
            this.trace.addEntry(statement.getPosition(), var, entry);
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

