/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorManager;
import org.evosuite.assertion.InspectorTraceEntry;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class InspectorTraceObserver
extends AssertionTraceObserver<InspectorTraceEntry> {
    private static Pattern addressPattern = Pattern.compile(".*[\\w+\\.]+@[abcdef\\d]+.*", 8);

    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        Statement declaringStatement = currentTest.getStatement(var.getStPosition());
        if (declaringStatement instanceof PrimitiveStatement) {
            return;
        }
        if (statement.isAssignmentStatement() && statement.getReturnValue().isArrayIndex()) {
            return;
        }
        if (statement instanceof ConstructorStatement && (statement.getReturnValue().isWrapperType() || statement.getReturnValue().isAssignableTo((Type)((Object)EvoSuiteMock.class)))) {
            return;
        }
        if (var.isPrimitive() || var.isString() || var.isWrapperType()) {
            return;
        }
        logger.debug("Checking for inspectors of " + var + " at statement " + statement.getPosition());
        List<Inspector> inspectors = InspectorManager.getInstance().getInspectors(var.getVariableClass());
        InspectorTraceEntry entry = new InspectorTraceEntry(var);
        for (Inspector i : inspectors) {
            if (i.getMethod().getDeclaringClass().equals(Object.class)) continue;
            try {
                Object target = var.getObject(scope);
                if (target == null) continue;
                if (target.getClass().getCanonicalName().contains("EnhancerByMockito")) {
                    return;
                }
                Object value = i.getValue(target);
                logger.debug("Inspector " + i.getMethodCall() + " is: " + value);
                if (value instanceof String && (((String)value).length() >= Short.MAX_VALUE || ((String)value).length() > Properties.MAX_STRING || addressPattern.matcher((String)value).find() || ((String)value).toLowerCase().contains("hashcode") || ((String)value).toLowerCase().contains("EnhancerByMockito") || ((String)value).toLowerCase().contains("$MockitoMock$") || target instanceof URL && (((String)value).startsWith("/") || ((String)value).startsWith("file:/")))) continue;
                entry.addValue(i, value);
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) {
                    logger.debug("Timeout during inspector call - deactivating inspector " + i.getMethodCall());
                    InspectorManager.getInstance().removeInspector(var.getVariableClass(), i);
                }
                logger.debug("Exception " + e + " / " + e.getCause());
                if (e.getCause() == null || e.getCause().getClass().equals(NullPointerException.class)) continue;
                logger.debug("Exception during call to inspector: " + e + " - " + e.getCause());
            }
        }
        logger.debug("Found " + entry.size() + " inspectors for " + var + " at statement " + statement.getPosition());
        this.trace.addEntry(statement.getPosition(), var, entry);
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

