/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.regression.ObjectDistanceCalculator;
import org.evosuite.testcase.variable.VariableReference;

public class PrimitiveTraceEntry
implements OutputTraceEntry {
    protected VariableReference var;
    protected Object value;

    public PrimitiveTraceEntry(VariableReference var, Object value) {
        this.var = var;
        this.value = value;
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof PrimitiveTraceEntry) {
            PrimitiveTraceEntry otherEntry = (PrimitiveTraceEntry)other;
            if (!this.value.equals(otherEntry.value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        PrimitiveTraceEntry otherEntry;
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof PrimitiveTraceEntry && (otherEntry = (PrimitiveTraceEntry)other) != null && otherEntry.value != null && this.value != null && this.var.getStPosition() == otherEntry.var.getStPosition() && !this.value.equals(otherEntry.value)) {
            double distance = ObjectDistanceCalculator.getObjectDistance(this.value, otherEntry.value);
            if (distance == 0.0) {
                return assertions;
            }
            PrimitiveAssertion assertion = new PrimitiveAssertion();
            assertion.value = this.value;
            assertion.source = this.var;
            if (Properties.isRegression()) {
                assertion.setComment("// (Primitive) Original Value: " + this.value + " | Regression Value: " + otherEntry.value);
            }
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        PrimitiveAssertion assertion = new PrimitiveAssertion();
        assertion.source = this.var;
        assertion.value = this.value;
        assertions.add(assertion);
        assert (assertion.isValid());
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof PrimitiveAssertion) {
            PrimitiveAssertion ass = (PrimitiveAssertion)assertion;
            if (this.var.same(ass.source)) {
                return !this.value.equals(ass.value);
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        return new PrimitiveTraceEntry(this.var, this.value);
    }
}

