/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class PrimitiveTraceObserver
extends AssertionTraceObserver<PrimitiveTraceEntry> {
    private static Pattern addressPattern = Pattern.compile(".*[\\w+\\.]+@[abcdef\\d]+.*", 8);

    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        if (statement instanceof FunctionalMockStatement) {
            return;
        }
        this.visitReturnValue(statement, scope);
    }

    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        if (statement.isAssignmentStatement()) {
            return;
        }
        logger.debug("Checking primitive " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (statement instanceof MethodStatement && ((MethodStatement)statement).getMethod().getName().equals("hashCode")) {
                return;
            }
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (object.getClass().isEnum() && !Modifier.isPublic(object.getClass().getModifiers())) {
                return;
            }
            if (object.getClass().isPrimitive() || object.getClass().isEnum() || PrimitiveTraceObserver.isWrapperType(object.getClass()) || object instanceof String) {
                if (object instanceof String) {
                    int length = ((String)object).length();
                    if (length > Properties.MAX_STRING) {
                        return;
                    }
                    if (length >= Short.MAX_VALUE) {
                        return;
                    }
                    if (((String)object).toLowerCase().contains("EnhancerByMockito")) {
                        return;
                    }
                    if (((String)object).toLowerCase().contains("hashcode")) {
                        return;
                    }
                    if (addressPattern.matcher((String)object).find()) {
                        return;
                    }
                }
                logger.debug("Observed value " + object + " for statement " + statement.getCode());
                this.trace.addEntry(statement.getPosition(), var, new PrimitiveTraceEntry(var, object));
            }
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

