/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobExecutor;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.persistency.StorageManager;
import org.evosuite.continuous.project.ProjectAnalyzer;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.utils.FileIOUtils;
import org.evosuite.xsd.Project;
import org.evosuite.xsd.ProjectUtil;

public class ContinuousTestGeneration {
    private final String target;
    private final String prefix;
    private final String projectClassPath;
    private CtgConfiguration configuration;
    private final String exportFolder;
    private String[] cuts;

    public ContinuousTestGeneration(String target, String projectClassPath, String prefix, CtgConfiguration conf, String[] cuts, String exportFolder) {
        this.target = target;
        this.prefix = prefix;
        this.projectClassPath = projectClassPath;
        this.configuration = conf;
        this.cuts = cuts;
        this.exportFolder = exportFolder;
    }

    public String execute() {
        StorageManager storage = new StorageManager();
        if (!storage.isStorageOk()) {
            return "Failed to initialize local storage system";
        }
        if (Properties.CTG_DELETE_OLD_TMP_FOLDERS) {
            storage.deleteAllOldTmpFolders();
        }
        if (!storage.createNewTmpFolders()) {
            return "Failed to create tmp folders";
        }
        ProjectAnalyzer analyzer = new ProjectAnalyzer(this.target, this.prefix, this.cuts);
        ProjectStaticData data = analyzer.analyze();
        if (data.getTotalNumberOfTestableCUTs() == 0) {
            return "There is no class to test in the chosen project\nTarget: " + this.target + "\nPrefix: '" + this.prefix + "'\n";
        }
        if (Properties.CTG_DEBUG_PORT != null && data.getTotalNumberOfTestableCUTs() != 1) {
            throw new IllegalStateException("Cannot debug CTG when more than one CUT is selected");
        }
        if (Properties.CTG_TIME_PER_CLASS != null) {
            this.configuration = this.configuration.getWithChangedTime(Properties.CTG_TIME_PER_CLASS, data.getTotalNumberOfTestableCUTs());
        }
        JobScheduler scheduler = new JobScheduler(data, this.configuration);
        JobExecutor executor = new JobExecutor(storage, this.projectClassPath, this.configuration);
        while (scheduler.canExecuteMore()) {
            List<JobDefinition> jobs = scheduler.createNewSchedule();
            executor.executeJobs(jobs, this.configuration.getNumberOfUsableCores());
            executor.waitForJobs();
        }
        String description = storage.mergeAndCommitChanges(data, this.cuts);
        if (this.exportFolder != null) {
            try {
                ContinuousTestGeneration.exportToFolder(".", this.exportFolder);
            }
            catch (IOException e) {
                return "Failed to export tests: " + e.getMessage();
            }
        }
        if (this.configuration.callHome) {
            // empty if block
        }
        return description;
    }

    public static File resolveExportFolder(String baseFolder, String exportFolder) {
        Path exp = Paths.get(exportFolder, new String[0]);
        if (exp.isAbsolute()) {
            return exp.toFile();
        }
        return Paths.get(baseFolder, exportFolder).toAbsolutePath().toFile();
    }

    public static boolean exportToFolder(String baseFolder, String exportFolder) throws IOException {
        boolean isEmpty;
        File basedir = new File(baseFolder);
        File evoFolder = StorageManager.getBestTestFolder(basedir);
        File[] children = evoFolder.listFiles();
        boolean bl = isEmpty = children == null || children.length == 0;
        if (isEmpty) {
            return false;
        }
        File target = ContinuousTestGeneration.resolveExportFolder(baseFolder, exportFolder);
        FileIOUtils.copyDirectoryAndOverwriteFilesIfNeeded(evoFolder, target);
        return true;
    }

    public boolean clean() {
        StorageManager storage = new StorageManager();
        return storage.clean();
    }

    public String info() {
        Project project = StorageManager.getDatabaseProject();
        if (project == null) {
            return "No info available";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Total number of classes in the project: " + ProjectUtil.getNumberTestableClasses(project) + "\n");
        sb.append("Number of classes in the project that are testable: " + ProjectUtil.getNumberTestableClasses(project) + "\n");
        sb.append("Number of generated test suites: " + ProjectUtil.getNumberGeneratedTestSuites(project) + "\n");
        sb.append("Overall coverage: " + ProjectUtil.getOverallCoverage(project) + "\n");
        return sb.toString();
    }
}

