/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.ScheduleType;
import org.evosuite.utils.LoggingUtils;

public abstract class OneTimeSchedule
extends ScheduleType {
    private boolean called = false;

    public OneTimeSchedule(JobScheduler scheduler) {
        super(scheduler);
    }

    @Override
    public final boolean canExecuteMore() {
        return !this.called;
    }

    @Override
    public final List<JobDefinition> createNewSchedule() {
        if (this.called) {
            throw new IllegalStateException("Schedule has already been created");
        }
        this.called = true;
        if (!this.enoughBudgetForAll()) {
            LoggingUtils.getEvoLogger().info("There is no enough time budget to generate test cases for all classes in the project");
            return this.createScheduleForWhenNotEnoughBudget();
        }
        return this.createScheduleOnce();
    }

    protected abstract List<JobDefinition> createScheduleOnce();

    protected void distributeExtraBudgetEvenly(List<JobDefinition> jobs, int totalLeftOver, int maximumBudgetPerCore) {
        int counter = 0;
        for (int i = 0; i < jobs.size(); ++i) {
            JobDefinition job = jobs.get(i);
            assert (job.seconds <= maximumBudgetPerCore);
            if (job.seconds >= maximumBudgetPerCore) continue;
            ++counter;
        }
        if (totalLeftOver < counter || counter == 0) {
            return;
        }
        int extraPerJob = totalLeftOver / counter;
        for (int i = 0; i < jobs.size(); ++i) {
            JobDefinition job = jobs.get(i);
            int toAdd = Math.min(extraPerJob, maximumBudgetPerCore - job.seconds);
            if (toAdd <= 0) continue;
            totalLeftOver -= toAdd;
            jobs.set(i, job.getByAddingBudget(toAdd));
        }
        if (totalLeftOver > 0 && totalLeftOver >= counter) {
            this.distributeExtraBudgetEvenly(jobs, totalLeftOver, maximumBudgetPerCore);
        }
    }
}

