/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.OneTimeSchedule;
import org.evosuite.continuous.job.schedule.SimpleSchedule;
import org.evosuite.continuous.project.ProjectGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedingSchedule
extends OneTimeSchedule {
    private static Logger logger = LoggerFactory.getLogger(SeedingSchedule.class);
    protected final OneTimeSchedule base;

    public SeedingSchedule(JobScheduler scheduler) {
        this(scheduler, new SimpleSchedule(scheduler));
    }

    protected SeedingSchedule(JobScheduler scheduler, OneTimeSchedule base) {
        super(scheduler);
        this.base = base;
    }

    @Override
    protected List<JobDefinition> createScheduleOnce() {
        List<JobDefinition> jobs = this.base.createScheduleOnce();
        if (logger.isDebugEnabled()) {
            logger.debug("Base schedule: " + jobs);
        }
        return this.addDepenciesAndSort(jobs);
    }

    @Override
    protected List<JobDefinition> createScheduleForWhenNotEnoughBudget() {
        List<JobDefinition> jobs = super.createScheduleForWhenNotEnoughBudget();
        if (logger.isDebugEnabled()) {
            logger.debug("Base, reduced schedule: " + jobs);
        }
        return this.addDepenciesAndSort(jobs);
    }

    protected List<JobDefinition> addDepenciesAndSort(List<JobDefinition> jobs) {
        jobs = this.addDependenciesForSeeding(jobs);
        if (logger.isDebugEnabled()) {
            logger.debug("Schedule after adding dependencies: " + jobs);
        }
        jobs = SeedingSchedule.getSortedToSatisfyDependencies(jobs);
        if (logger.isDebugEnabled()) {
            logger.debug("Final schedule after sorting: " + jobs);
        }
        return jobs;
    }

    protected static List<JobDefinition> getSortedToSatisfyDependencies(List<JobDefinition> jobs) {
        LinkedList<JobDefinition> toAssign = new LinkedList<JobDefinition>(jobs);
        LinkedList<JobDefinition> postponed = new LinkedList<JobDefinition>();
        ArrayList<JobDefinition> out = new ArrayList<JobDefinition>(jobs.size());
        HashSet<String> assigned = new HashSet<String>();
        while (!toAssign.isEmpty() || !postponed.isEmpty()) {
            JobDefinition chosenJob = null;
            if (!postponed.isEmpty()) {
                Iterator iterator = postponed.iterator();
                while (iterator.hasNext()) {
                    JobDefinition job = (JobDefinition)iterator.next();
                    if (!job.areDependenciesSatisfied(jobs, assigned)) continue;
                    chosenJob = job;
                    iterator.remove();
                    break;
                }
            }
            if (chosenJob == null && toAssign.isEmpty()) {
                assert (!postponed.isEmpty());
                chosenJob = (JobDefinition)postponed.remove(0);
            }
            if (chosenJob == null) {
                assert (!toAssign.isEmpty());
                while (!toAssign.isEmpty()) {
                    JobDefinition job = (JobDefinition)toAssign.poll();
                    if (job.areDependenciesSatisfied(jobs, assigned)) {
                        chosenJob = job;
                        break;
                    }
                    postponed.add(job);
                }
                if (chosenJob == null) {
                    assert (!postponed.isEmpty() && toAssign.isEmpty());
                    continue;
                }
            }
            out.add(chosenJob);
            assigned.add(chosenJob.cut);
        }
        return out;
    }

    protected List<JobDefinition> addDependenciesForSeeding(List<JobDefinition> jobs) {
        ArrayList<JobDefinition> list = new ArrayList<JobDefinition>(jobs.size());
        for (int i = 0; i < jobs.size(); ++i) {
            JobDefinition job = jobs.get(i);
            Set<String> inputs = this.calculateInputClasses(job);
            Set<String> parents = this.calculateAncestors(job);
            list.add(job.getByAddingDependencies(inputs, parents));
        }
        return list;
    }

    private Set<String> calculateInputClasses(JobDefinition job) {
        LinkedHashSet<String> dep = new LinkedHashSet<String>();
        ProjectGraph graph = this.scheduler.getProjectData().getProjectGraph();
        for (String input : graph.getCUTsDirectlyUsedAsInput(job.cut, true)) {
            if (graph.isInterface(input)) continue;
            dep.add(input);
        }
        return dep;
    }

    private Set<String> calculateAncestors(JobDefinition job) {
        LinkedHashSet<String> dep = new LinkedHashSet<String>();
        ProjectGraph graph = this.scheduler.getProjectData().getProjectGraph();
        if (graph.isInterface(job.cut)) {
            return dep;
        }
        for (String parent : graph.getAllCUTsParents(job.cut)) {
            if (graph.isInterface(parent)) continue;
            dep.add(parent);
        }
        return dep;
    }
}

