/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.OneTimeSchedule;
import org.evosuite.continuous.project.ProjectStaticData;

public class SimpleSchedule
extends OneTimeSchedule {
    public SimpleSchedule(JobScheduler scheduler) {
        super(scheduler);
    }

    @Override
    protected List<JobDefinition> createScheduleOnce() {
        assert (this.enoughBudgetForAll());
        ProjectStaticData data = this.scheduler.getProjectData();
        int totalBudgetInSeconds = 60 * this.scheduler.getConfiguration().timeInMinutes * this.scheduler.getConfiguration().getNumberOfUsableCores();
        LinkedList<JobDefinition> jobs = new LinkedList<JobDefinition>();
        int cores = this.scheduler.getConfiguration().getNumberOfUsableCores();
        int cuts = data.getTotalNumberOfTestableCUTs();
        int slots = (int)Math.round((double)cores * Math.ceil((double)cuts / (double)cores));
        int budgetInSecondsPerCUT = totalBudgetInSeconds / slots;
        for (ProjectStaticData.ClassInfo info : data.getClassInfos()) {
            if (!info.isTestable()) continue;
            JobDefinition job = new JobDefinition(budgetInSecondsPerCUT, this.scheduler.getConfiguration().getConstantMemoryPerJob(), info.getClassName(), 0, null, null);
            jobs.add(job);
        }
        return jobs;
    }
}

