/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.continuous.persistency.StorageManager;
import org.evosuite.continuous.project.ProjectGraph;
import org.evosuite.xsd.CUT;
import org.evosuite.xsd.Generation;
import org.evosuite.xsd.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectStaticData {
    private static Logger logger = LoggerFactory.getLogger(ProjectStaticData.class);
    private final Map<String, ClassInfo> classes = new ConcurrentHashMap<String, ClassInfo>();
    private final Set<String> modifiedFiles = new LinkedHashSet<String>();
    private Project project = null;
    private ProjectGraph graph = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeLocalHistory() {
        if (Properties.CTG_HISTORY_FILE == null) {
            logger.info("ctg history file is not set");
            return;
        }
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(Properties.CTG_HISTORY_FILE));
            block24: while ((sCurrentLine = br.readLine()) != null) {
                String[] split = sCurrentLine.split("\t");
                switch (split[0]) {
                    case "A": 
                    case "M": {
                        if (!split[1].endsWith(".java")) continue block24;
                        this.modifiedFiles.add(split[1].replace(File.separator, "."));
                        continue block24;
                    }
                    case "D": {
                        continue block24;
                    }
                }
                logger.error("option '" + split[0] + "' in the " + Properties.CTG_HISTORY_FILE + " file not supported");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("'" + Properties.CTG_HISTORY_FILE + "' file not found");
        }
        catch (IOException e) {
            logger.error("error reading '" + Properties.CTG_HISTORY_FILE + "' file", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.project = StorageManager.getDatabaseProject();
    }

    protected void addNewClass(ClassInfo info) {
        this.classes.put(info.getClassName(), info);
    }

    public boolean containsClass(String c) {
        return this.classes.containsKey(c);
    }

    public ClassInfo getClassInfo(String name) {
        return this.classes.get(name);
    }

    public int getTotalNumberOfClasses() {
        return this.classes.size();
    }

    public int getTotalNumberOfTestableCUTs() {
        int total = 0;
        for (ClassInfo info : this.classes.values()) {
            if (!info.isTestable()) continue;
            ++total;
        }
        return total;
    }

    public int getTotalNumberOfBranches() {
        int total = 0;
        for (ClassInfo info : this.classes.values()) {
            total += info.numberOfBranches;
        }
        return total;
    }

    public Collection<ClassInfo> getClassInfos() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableCollection(this.classes.keySet());
    }

    public boolean hasChanged(String javaFileName) {
        return this.modifiedFiles.parallelStream().anyMatch(m -> m.endsWith(javaFileName));
    }

    protected void setProject(Project project) {
        this.project = project;
    }

    public boolean isToTest(String className, int n) {
        if (this.project == null) {
            return true;
        }
        CUT cut = this.project.getCut().parallelStream().filter(p -> p.getFullNameOfTargetClass().equals(className)).findFirst().orElse(null);
        if (cut == null) {
            return true;
        }
        int how_many_generations_so_far = cut.getGeneration().size();
        if (cut.getGeneration().get(how_many_generations_so_far - 1).isFailed()) {
            return true;
        }
        if (how_many_generations_so_far < n) {
            return true;
        }
        List lastNGenerations = cut.getGeneration().stream().filter(g -> g.getTimeBudgetInSeconds().intValue() > 0).skip(how_many_generations_so_far - n).collect(Collectors.toList());
        for (int i = lastNGenerations.size() - 1; i >= 0; --i) {
            Generation generation = (Generation)lastNGenerations.get(i);
            if (generation.isFailed()) {
                return true;
            }
            if (generation.getSuite() == null) continue;
            return true;
        }
        return false;
    }

    public ProjectGraph getProjectGraph() {
        if (this.graph == null) {
            this.graph = new ProjectGraph(this);
        }
        return this.graph;
    }

    public static class ClassInfo {
        public final Class<?> theClass;
        public final int numberOfBranches;
        public final boolean hasCode;
        private boolean hasChanged = true;
        private boolean isToTest = true;
        private int timeBudgetInSeconds = 0;
        private int memoryInMB = 0;

        public ClassInfo(Class<?> theClass, int numberOfBranches, boolean hasCode) {
            this.theClass = theClass;
            this.numberOfBranches = numberOfBranches;
            this.hasCode = hasCode;
        }

        public String getClassName() {
            return this.theClass.getName();
        }

        public boolean isTestable() {
            return this.hasCode;
        }

        public void setChanged(boolean changed) {
            this.hasChanged = changed;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void isToTest(boolean isToTest) {
            this.isToTest = isToTest;
        }

        public boolean isToTest() {
            return this.isToTest;
        }

        public void setTimeBudgetInSeconds(int timeBudgetInSeconds) {
            this.timeBudgetInSeconds = timeBudgetInSeconds;
        }

        public int getTimeBudgetInSeconds() {
            return this.timeBudgetInSeconds;
        }

        public void setMemoryInMB(int memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        public int getMemoryInMB() {
            return this.memoryInMB;
        }
    }
}

