/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchPool {
    private static Logger logger = LoggerFactory.getLogger(BranchPool.class);
    private Map<String, Map<String, List<Branch>>> branchMap = new HashMap<String, Map<String, List<Branch>>>();
    private Map<String, Map<String, Integer>> branchlessMethods = new HashMap<String, Map<String, Integer>>();
    private Map<Integer, Branch> branchIdMap = new HashMap<Integer, Branch>();
    private Map<BytecodeInstruction, Integer> registeredNormalBranches = new HashMap<BytecodeInstruction, Integer>();
    private Map<BytecodeInstruction, List<Branch>> registeredSwitches = new HashMap<BytecodeInstruction, List<Branch>>();
    private Map<BytecodeInstruction, Branch> registeredDefaultCases = new HashMap<BytecodeInstruction, Branch>();
    private Map<LabelNode, List<Branch>> switchLabels = new HashMap<LabelNode, List<Branch>>();
    private int branchCounter = 0;
    private static Map<ClassLoader, BranchPool> instanceMap = new HashMap<ClassLoader, BranchPool>();

    public static BranchPool getInstance(ClassLoader classLoader) {
        if (!instanceMap.containsKey(classLoader)) {
            instanceMap.put(classLoader, new BranchPool());
        }
        return instanceMap.get(classLoader);
    }

    public void addBranchlessMethod(String className, String methodName, int lineNumber) {
        if (!this.branchlessMethods.containsKey(className)) {
            this.branchlessMethods.put(className, new HashMap());
        }
        this.branchlessMethods.get(className).put(methodName, lineNumber);
    }

    public void registerAsBranch(BytecodeInstruction instruction) {
        if (!instruction.isActualBranch()) {
            throw new IllegalArgumentException("CFGVertex of a branch expected");
        }
        if (this.isKnownAsBranch(instruction)) {
            return;
        }
        if (!DependencyAnalysis.shouldInstrument(instruction.getClassName(), instruction.getMethodName())) {
            return;
        }
        this.registerInstruction(instruction);
    }

    private void registerInstruction(BytecodeInstruction v) {
        if (this.isKnownAsBranch(v)) {
            throw new IllegalStateException("expect registerInstruction() to be called at most once for each instruction");
        }
        if (v.isBranch()) {
            this.registerNormalBranchInstruction(v);
        } else if (v.isSwitch()) {
            this.registerSwitchInstruction(v);
        } else {
            throw new IllegalArgumentException("expect given instruction to be an actual branch");
        }
    }

    private void registerNormalBranchInstruction(BytecodeInstruction v) {
        if (!v.isBranch()) {
            throw new IllegalArgumentException("normal branch instruction expceted");
        }
        if (this.registeredNormalBranches.containsKey(v)) {
            throw new IllegalArgumentException("instruction already registered as a normal branch");
        }
        ++this.branchCounter;
        this.registeredNormalBranches.put(v, this.branchCounter);
        Branch b = new Branch(v, this.branchCounter);
        this.addBranchToMap(b);
        this.branchIdMap.put(this.branchCounter, b);
        logger.info("Branch " + this.branchCounter + " at line " + v.getLineNumber());
    }

    private void registerSwitchInstruction(BytecodeInstruction v) {
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("expect a switch instruction");
        }
        LabelNode defaultLabel = null;
        switch (v.getASMNode().getOpcode()) {
            case 170: {
                TableSwitchInsnNode tableSwitchNode = (TableSwitchInsnNode)v.getASMNode();
                this.registerTableSwitchCases(v, tableSwitchNode);
                defaultLabel = tableSwitchNode.dflt;
                break;
            }
            case 171: {
                LookupSwitchInsnNode lookupSwitchNode = (LookupSwitchInsnNode)v.getASMNode();
                this.registerLookupSwitchCases(v, lookupSwitchNode);
                defaultLabel = lookupSwitchNode.dflt;
                break;
            }
            default: {
                throw new IllegalStateException("expect ASMNode of a switch to either be a LOOKUP- or TABLESWITCH");
            }
        }
        this.registerDefaultCase(v, defaultLabel);
    }

    private void registerDefaultCase(BytecodeInstruction v, LabelNode defaultLabel) {
        if (defaultLabel == null) {
            throw new IllegalStateException("expect variable to bet set");
        }
        Branch defaultBranch = this.createSwitchCaseBranch(v, null, defaultLabel);
        if (!defaultBranch.isSwitchCaseBranch() || !defaultBranch.isDefaultCase()) {
            throw new IllegalStateException("expect created branch to be a default case branch of a switch");
        }
    }

    private void registerTableSwitchCases(BytecodeInstruction v, TableSwitchInsnNode tableSwitchNode) {
        int num = 0;
        for (int i = tableSwitchNode.min; i <= tableSwitchNode.max; ++i) {
            LabelNode targetLabel = tableSwitchNode.labels.get(num);
            Branch switchBranch = this.createSwitchCaseBranch(v, i, targetLabel);
            if (!switchBranch.isSwitchCaseBranch() || !switchBranch.isActualCase()) {
                throw new IllegalStateException("expect created branch to be an actual case branch of a switch");
            }
            ++num;
        }
    }

    private void registerLookupSwitchCases(BytecodeInstruction v, LookupSwitchInsnNode lookupSwitchNode) {
        for (int i = 0; i < lookupSwitchNode.keys.size(); ++i) {
            LabelNode targetLabel = lookupSwitchNode.labels.get(i);
            Branch switchBranch = this.createSwitchCaseBranch(v, lookupSwitchNode.keys.get(i), targetLabel);
            if (switchBranch.isSwitchCaseBranch() && switchBranch.isActualCase()) continue;
            throw new IllegalStateException("expect created branch to be an actual case branch of a switch");
        }
    }

    private Branch createSwitchCaseBranch(BytecodeInstruction v, Integer caseValue, LabelNode targetLabel) {
        ++this.branchCounter;
        Branch switchBranch = new Branch(v, caseValue, targetLabel, this.branchCounter);
        this.registerSwitchBranch(v, switchBranch);
        this.addBranchToMap(switchBranch);
        this.branchIdMap.put(this.branchCounter, switchBranch);
        this.registerSwitchLabel(switchBranch, targetLabel);
        if (caseValue == null) {
            if (this.registeredDefaultCases.containsKey(v)) {
                throw new IllegalStateException("instruction already registered as a branch");
            }
            this.registeredDefaultCases.put(v, switchBranch);
        }
        if (!switchBranch.isSwitchCaseBranch()) {
            throw new IllegalStateException("expect created Branch to be a switch branch");
        }
        return switchBranch;
    }

    private void registerSwitchLabel(Branch b, LabelNode targetLabel) {
        List<Branch> oldList;
        if (this.switchLabels.get(targetLabel) == null) {
            this.switchLabels.put(targetLabel, new ArrayList());
        }
        if ((oldList = this.switchLabels.get(targetLabel)).contains(b)) {
            throw new IllegalStateException("branch already registered for this switch label");
        }
        oldList.add(b);
        this.switchLabels.put(targetLabel, oldList);
    }

    private void registerSwitchBranch(BytecodeInstruction v, Branch switchBranch) {
        List<Branch> oldList;
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (this.registeredSwitches.get(v) == null) {
            this.registeredSwitches.put(v, new ArrayList());
        }
        if ((oldList = this.registeredSwitches.get(v)).contains(switchBranch)) {
            throw new IllegalArgumentException("switch branch already registered  " + switchBranch.toString());
        }
        oldList.add(switchBranch);
        this.registeredSwitches.put(v, oldList);
    }

    private void addBranchToMap(Branch b) {
        logger.info("Adding to map the branch {}", (Object)b);
        String className = b.getClassName();
        String methodName = b.getMethodName();
        if (!this.branchMap.containsKey(className)) {
            this.branchMap.put(className, new HashMap());
        }
        if (!this.branchMap.get(className).containsKey(methodName)) {
            this.branchMap.get(className).put(methodName, new ArrayList());
        }
        this.branchMap.get(className).get(methodName).add(b);
    }

    public boolean isKnownAsBranch(BytecodeInstruction instruction) {
        return this.isKnownAsNormalBranchInstruction(instruction) || this.isKnownAsSwitchBranchInstruction(instruction);
    }

    public boolean isKnownAsNormalBranchInstruction(BytecodeInstruction ins) {
        return this.registeredNormalBranches.containsKey(ins);
    }

    public boolean isKnownAsSwitchBranchInstruction(BytecodeInstruction instruction) {
        return this.registeredSwitches.containsKey(instruction);
    }

    public int getActualBranchIdForNormalBranchInstruction(BytecodeInstruction ins) {
        if (!this.isKnownAsNormalBranchInstruction(ins)) {
            throw new IllegalArgumentException("instruction not registered as a normal branch");
        }
        if (this.registeredNormalBranches.containsKey(ins)) {
            return this.registeredNormalBranches.get(ins);
        }
        throw new IllegalStateException("expect registeredNormalBranches to contain a key for each known normal branch instruction");
    }

    public List<Branch> getCaseBranchesForSwitch(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!instruction.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (!this.isKnownAsSwitchBranchInstruction(instruction)) {
            throw new IllegalArgumentException("not registered as a switch instruction");
        }
        return this.registeredSwitches.get(instruction);
    }

    public Branch getBranchForInstruction(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.isKnownAsNormalBranchInstruction(instruction)) {
            throw new IllegalArgumentException("expect given instruction to be known as a normal branch");
        }
        return this.getBranch(this.registeredNormalBranches.get(instruction));
    }

    public List<Branch> getBranchForLabel(LabelNode label) {
        return this.switchLabels.get(label);
    }

    public int getBranchCountForMethod(String className, String methodName) {
        if (this.branchMap.get(className) == null) {
            return 0;
        }
        if (this.branchMap.get(className).get(methodName) == null) {
            return 0;
        }
        return this.branchMap.get(className).get(methodName).size();
    }

    public int getNonArtificialBranchCountForMethod(String className, String methodName) {
        if (this.branchMap.get(className) == null) {
            return 0;
        }
        if (this.branchMap.get(className).get(methodName) == null) {
            return 0;
        }
        int num = 0;
        for (Branch b : this.branchMap.get(className).get(methodName)) {
            if (b.isInstrumented()) continue;
            ++num;
        }
        return num;
    }

    public int getBranchCountForClass(String className) {
        if (this.branchMap.get(className) == null) {
            return 0;
        }
        int total = 0;
        for (String method : this.branchMap.get(className).keySet()) {
            total += this.branchMap.get(className).get(method).size();
        }
        return total;
    }

    public int getBranchCountForPrefix(String prefix) {
        int num = 0;
        for (String className : this.branchMap.keySet()) {
            if (!className.startsWith(prefix)) continue;
            logger.info("Found matching class for branch count: " + className + "/" + prefix);
            for (String method : this.branchMap.get(className).keySet()) {
                num += this.branchMap.get(className).get(method).size();
            }
        }
        return num;
    }

    public Set<Integer> getBranchIdsForPrefix(String prefix) {
        HashSet<Integer> ids = new HashSet<Integer>();
        HashSet sutBranches = new HashSet();
        for (String className : this.branchMap.keySet()) {
            if (!className.startsWith(prefix)) continue;
            logger.info("Found matching class for branch ids: " + className + "/" + prefix);
            for (String method : this.branchMap.get(className).keySet()) {
                sutBranches.addAll(this.branchMap.get(className).get(method));
            }
        }
        for (Integer id : this.branchIdMap.keySet()) {
            if (!sutBranches.contains(this.branchIdMap.get(id))) continue;
            ids.add(id);
        }
        return ids;
    }

    public int getBranchCountForMemberClasses(String prefix) {
        int num = 0;
        for (String className : this.branchMap.keySet()) {
            if (!className.equals(prefix) && !className.startsWith(prefix + "$")) continue;
            logger.info("Found matching class for branch count: " + className + "/" + prefix);
            for (String method : this.branchMap.get(className).keySet()) {
                num += this.branchMap.get(className).get(method).size();
            }
        }
        return num;
    }

    public int getBranchCounter() {
        return this.branchCounter;
    }

    public int getNumArtificialBranches() {
        int num = 0;
        for (Branch b : this.branchIdMap.values()) {
            if (!b.isInstrumented()) continue;
            ++num;
        }
        return num;
    }

    public Branch getBranch(int branchId) {
        return this.branchIdMap.get(branchId);
    }

    public Collection<Branch> getAllBranches() {
        return this.branchIdMap.values();
    }

    public Set<String> getBranchlessMethods(String className) {
        if (!this.branchlessMethods.containsKey(className)) {
            return new HashSet<String>();
        }
        return this.branchlessMethods.get(className).keySet();
    }

    public Set<String> getBranchlessMethodsPrefix(String className) {
        HashSet<String> methods = new HashSet<String>();
        for (String name : this.branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            methods.addAll(this.branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public Set<String> getBranchlessMethodsMemberClasses(String className) {
        HashSet<String> methods = new HashSet<String>();
        for (String name : this.branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            methods.addAll(this.branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public int getBranchlessMethodLineNumber(String className, String methodName) {
        if (this.branchlessMethods.get(className) != null && this.branchlessMethods.get(className).get(className + "." + methodName) != null) {
            return this.branchlessMethods.get(className).get(className + "." + methodName);
        }
        return this.branchlessMethods.get(className).get(className + "." + methodName);
    }

    public Set<String> getBranchlessMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (String name : this.branchlessMethods.keySet()) {
            methods.addAll(this.branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public boolean isBranchlessMethod(String className, String methodName) {
        Map<String, Integer> methodMap = this.branchlessMethods.get(className);
        if (methodMap != null) {
            return methodMap.containsKey(methodName);
        }
        return false;
    }

    public int getNumBranchlessMethods(String className) {
        if (!this.branchlessMethods.containsKey(className)) {
            return 0;
        }
        return this.branchlessMethods.get(className).size();
    }

    public int getNumBranchlessMethodsPrefix(String className) {
        int num = 0;
        for (String name : this.branchlessMethods.keySet()) {
            if (!name.startsWith(className)) continue;
            num += this.branchlessMethods.get(name).size();
        }
        return num;
    }

    public int getNumBranchlessMethodsMemberClasses(String className) {
        int num = 0;
        for (String name : this.branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            num += this.branchlessMethods.get(name).size();
        }
        return num;
    }

    public int getNumBranchlessMethods() {
        int num = 0;
        for (String name : this.branchlessMethods.keySet()) {
            num += this.branchlessMethods.get(name).size();
        }
        return num;
    }

    public Set<String> knownClasses() {
        HashSet<String> r = new HashSet<String>();
        r.addAll(this.branchMap.keySet());
        r.addAll(this.branchlessMethods.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Known classes: " + r);
        }
        return r;
    }

    public Set<String> knownMethods(String className) {
        HashSet<String> r = new HashSet<String>();
        Map<String, List<Branch>> methods = this.branchMap.get(className);
        if (methods != null) {
            r.addAll(methods.keySet());
        }
        return r;
    }

    public List<Branch> retrieveBranchesInMethod(String className, String methodName) {
        ArrayList<Branch> r = new ArrayList<Branch>();
        if (this.branchMap.get(className) == null) {
            return r;
        }
        List<Branch> branches = this.branchMap.get(className).get(methodName);
        if (branches != null) {
            r.addAll(branches);
        }
        return r;
    }

    public Branch getDefaultBranchForSwitch(BytecodeInstruction v) {
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (!this.isKnownAsSwitchBranchInstruction(v)) {
            throw new IllegalArgumentException("instruction not known to be a switch instruction");
        }
        if (!this.registeredDefaultCases.containsKey(v)) {
            throw new IllegalArgumentException("there is no registered default case for this instruction");
        }
        return this.registeredDefaultCases.get(v);
    }

    public void reset() {
        this.branchCounter = 0;
        this.branchMap.clear();
        this.branchlessMethods.clear();
        this.branchIdMap.clear();
        this.registeredNormalBranches.clear();
        this.registeredSwitches.clear();
        this.registeredDefaultCases.clear();
        this.switchLabels.clear();
    }

    public void clear() {
        this.branchCounter = 0;
        this.branchMap.clear();
        this.branchIdMap.clear();
        this.branchlessMethods.clear();
        this.switchLabels.clear();
        this.registeredDefaultCases.clear();
        this.registeredNormalBranches.clear();
        this.registeredSwitches.clear();
    }

    public void clear(String className) {
        this.branchMap.remove(className);
        this.branchlessMethods.remove(className);
    }

    public void clear(String className, String methodName) {
        int numBranches = 0;
        if (this.branchMap.containsKey(className)) {
            if (this.branchMap.get(className).containsKey(methodName)) {
                numBranches = this.branchMap.get(className).get(methodName).size();
            }
            this.branchMap.get(className).remove(methodName);
        }
        if (this.branchlessMethods.containsKey(className)) {
            this.branchlessMethods.get(className).remove(methodName);
        }
        logger.info("Resetting branchCounter from " + this.branchCounter + " to " + (this.branchCounter - numBranches));
        this.branchCounter -= numBranches;
    }
}

