/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import org.evosuite.Properties;
import org.evosuite.coverage.ControlFlowDistance;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class OnlyBranchCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -7540212369784578236L;
    private final BranchCoverageGoal goal;

    public OnlyBranchCoverageTestFitness(BranchCoverageGoal goal) throws IllegalArgumentException {
        if (goal == null) {
            throw new IllegalArgumentException("goal cannot be null");
        }
        this.goal = goal;
    }

    public Branch getBranch() {
        return this.goal.getBranch();
    }

    public boolean getValue() {
        return this.goal.getValue();
    }

    public BranchCoverageGoal getBranchGoal() {
        return this.goal;
    }

    public String getClassName() {
        return this.goal.getClassName();
    }

    public String getMethod() {
        return this.goal.getMethodName();
    }

    public boolean getBranchExpressionValue() {
        return this.goal.getValue();
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        ControlFlowDistance distance = this.goal.getDistance(result);
        double fitness = distance.getResultingBranchFitness();
        logger.debug("Approach level: " + distance.getApproachLevel() + " / branch distance: " + distance.getBranchDistance() + ", fitness = " + fitness);
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    public String toString() {
        return this.goal.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.goal == null ? 0 : this.goal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OnlyBranchCoverageTestFitness other = (OnlyBranchCoverageTestFitness)obj;
        return !(this.goal == null ? other.goal != null : !this.goal.equals(other.goal));
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof OnlyBranchCoverageTestFitness) {
            OnlyBranchCoverageTestFitness otherOnlyBranchFitness = (OnlyBranchCoverageTestFitness)other;
            return this.goal.compareTo(otherOnlyBranchFitness.goal);
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

