/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.Call;
import org.evosuite.setup.CallContext;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class IBranchSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 5836092966704859022L;
    private final List<IBranchTestFitness> branchGoals;
    private int totGoals;
    private final Map<Integer, Map<CallContext, Set<IBranchTestFitness>>> goalsMap;
    private final Map<String, Map<CallContext, IBranchTestFitness>> methodsMap;
    private final Set<IBranchTestFitness> toRemoveBranchesT = new LinkedHashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> toRemoveBranchesF = new LinkedHashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> toRemoveRootBranches = new LinkedHashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedBranchesT = new LinkedHashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedBranchesF = new LinkedHashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedRootBranches = new LinkedHashSet<IBranchTestFitness>();

    public IBranchSuiteFitness() {
        this.goalsMap = new LinkedHashMap<Integer, Map<CallContext, Set<IBranchTestFitness>>>();
        this.methodsMap = new LinkedHashMap<String, Map<CallContext, IBranchTestFitness>>();
        IBranchFitnessFactory factory = new IBranchFitnessFactory();
        this.branchGoals = factory.getCoverageGoals();
        this.countGoals(this.branchGoals);
        for (IBranchTestFitness goal : this.branchGoals) {
            Map<CallContext, Object> innermap;
            if (goal.getBranchGoal() != null && goal.getBranchGoal().getBranch() != null) {
                Set<IBranchTestFitness> tempInSet;
                int branchId = goal.getBranchGoal().getBranch().getActualBranchId();
                innermap = this.goalsMap.get(branchId);
                if (innermap == null) {
                    innermap = new LinkedHashMap();
                    this.goalsMap.put(branchId, innermap);
                }
                if ((tempInSet = innermap.get(goal.getContext())) == null) {
                    tempInSet = new LinkedHashSet<IBranchTestFitness>();
                    innermap.put(goal.getContext(), tempInSet);
                }
                tempInSet.add(goal);
                if (Properties.TEST_ARCHIVE) {
                    Archive.getArchiveInstance().addTarget(goal);
                }
            } else {
                String methodName = goal.getTargetClass() + "." + goal.getTargetMethod();
                innermap = this.methodsMap.get(methodName);
                if (innermap == null) {
                    innermap = new LinkedHashMap();
                    this.methodsMap.put(methodName, innermap);
                }
                innermap.put(goal.getContext(), (Set<IBranchTestFitness>)((Object)goal));
            }
            logger.info("Context goal: " + goal.toString());
        }
        this.totGoals = this.branchGoals.size();
    }

    private void countGoals(List<IBranchTestFitness> branchGoals) {
        int totalGoals = branchGoals.size();
        int goalsInTarget = 0;
        for (IBranchTestFitness g : branchGoals) {
            boolean flag = true;
            for (Call call : g.getContext().getContext()) {
                if (call.getClassName().equals(Properties.TARGET_CLASS)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            ++goalsInTarget;
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoals, totalGoals);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoalsInTargetClass, goalsInTarget);
    }

    private IBranchTestFitness getContextGoal(String classAndMethodName, CallContext context) {
        if (this.methodsMap.get(classAndMethodName) == null || this.methodsMap.get(classAndMethodName).get(context) == null) {
            return null;
        }
        return this.methodsMap.get(classAndMethodName).get(context);
    }

    private IBranchTestFitness getContextGoal(Integer branchId, CallContext context, boolean value) {
        if (this.goalsMap.get(branchId) == null) {
            return null;
        }
        if (this.goalsMap.get(branchId).get(context) == null) {
            return null;
        }
        for (IBranchTestFitness iBranchTestFitness : this.goalsMap.get(branchId).get(context)) {
            if (iBranchTestFitness.getValue() != value) continue;
            return iBranchTestFitness;
        }
        return null;
    }

    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, boolean updateChromosome) {
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashMap<IBranchTestFitness, Double> distanceMap = new LinkedHashMap<IBranchTestFitness, Double>();
        LinkedHashMap<IBranchTestFitness, Integer> callCount = new LinkedHashMap<IBranchTestFitness, Integer>();
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) continue;
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Integer n : result.getTrace().getTrueDistancesContext().keySet()) {
                Map<CallContext, Double> trueMap = result.getTrace().getTrueDistancesContext().get(n);
                for (CallContext context : trueMap.keySet()) {
                    IBranchTestFitness goalT = this.getContextGoal(n, context, true);
                    if (goalT == null || this.removedBranchesT.contains(goalT)) continue;
                    double distanceT = IBranchSuiteFitness.normalize(trueMap.get(context));
                    if (distanceMap.get(goalT) == null || (Double)distanceMap.get(goalT) > distanceT) {
                        distanceMap.put(goalT, distanceT);
                    }
                    if (Double.compare(distanceT, 0.0) == 0) {
                        if (updateChromosome) {
                            test.getTestCase().addCoveredGoal(goalT);
                        }
                        this.toRemoveBranchesT.add(goalT);
                    }
                    if (!Properties.TEST_ARCHIVE) continue;
                    Archive.getArchiveInstance().updateArchive(goalT, test, distanceT);
                }
            }
            for (Integer n : result.getTrace().getFalseDistancesContext().keySet()) {
                Map<CallContext, Double> falseMap = result.getTrace().getFalseDistancesContext().get(n);
                for (CallContext context : falseMap.keySet()) {
                    IBranchTestFitness goalF = this.getContextGoal(n, context, false);
                    if (goalF == null || this.removedBranchesF.contains(goalF)) continue;
                    double distanceF = IBranchSuiteFitness.normalize(falseMap.get(context));
                    if (distanceMap.get(goalF) == null || (Double)distanceMap.get(goalF) > distanceF) {
                        distanceMap.put(goalF, distanceF);
                    }
                    if (Double.compare(distanceF, 0.0) == 0) {
                        if (updateChromosome) {
                            test.getTestCase().addCoveredGoal(goalF);
                        }
                        this.toRemoveBranchesF.add(goalF);
                    }
                    if (!Properties.TEST_ARCHIVE) continue;
                    Archive.getArchiveInstance().updateArchive(goalF, test, distanceF);
                }
            }
            for (Map.Entry entry : result.getTrace().getMethodContextCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    IBranchTestFitness goal = this.getContextGoal((String)entry.getKey(), (CallContext)value.getKey());
                    if (goal == null || this.removedRootBranches.contains(goal)) continue;
                    int count = (Integer)value.getValue();
                    if (callCount.get(goal) == null || (Integer)callCount.get(goal) < count) {
                        callCount.put(goal, count);
                    }
                    if (count <= 0) continue;
                    if (updateChromosome) {
                        result.test.addCoveredGoal(goal);
                    }
                    this.toRemoveRootBranches.add(goal);
                }
            }
        }
        int numCoveredGoals = 0;
        for (IBranchTestFitness goal : this.branchGoals) {
            Double distance = (Double)distanceMap.get(goal);
            if (distance == null) {
                distance = 1.0;
            }
            if (goal.getBranch() == null) {
                Integer n = (Integer)callCount.get(goal);
                if (n == null || n == 0) {
                    fitness += 1.0;
                    continue;
                }
                ++numCoveredGoals;
                continue;
            }
            if (distance == 0.0) {
                ++numCoveredGoals;
            }
            fitness += distance.doubleValue();
        }
        if (updateChromosome) {
            numCoveredGoals += this.removedBranchesF.size();
            numCoveredGoals += this.removedBranchesT.size();
            numCoveredGoals += this.removedRootBranches.size();
            if (this.totGoals > 0) {
                suite.setCoverage(this, (double)numCoveredGoals / (double)this.totGoals);
            }
            suite.setNumOfCoveredGoals(this, numCoveredGoals);
            suite.setNumOfNotCoveredGoals(this, this.totGoals - numCoveredGoals);
            this.updateIndividual(this, suite, fitness);
        }
        return fitness;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        return this.getFitness(suite, true);
    }

    @Override
    public boolean updateCoveredGoals() {
        boolean f;
        Set set;
        Map<CallContext, Object> map;
        boolean removed;
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (IBranchTestFitness method : this.toRemoveRootBranches) {
            removed = this.branchGoals.remove(method);
            map = this.methodsMap.get(method.getTargetClass() + "." + method.getTargetMethod());
            IBranchTestFitness f2 = (IBranchTestFitness)map.remove(method.getContext());
            if (removed && f2 != null) {
                this.removedRootBranches.add(method);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (IBranchTestFitness branch : this.toRemoveBranchesT) {
            removed = this.branchGoals.remove(branch);
            map = this.goalsMap.get(branch.getBranch().getActualBranchId());
            set = (Set)map.get(branch.getContext());
            f = set.remove(branch);
            if (removed && f) {
                this.removedBranchesT.add(branch);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (IBranchTestFitness branch : this.toRemoveBranchesF) {
            removed = this.branchGoals.remove(branch);
            map = this.goalsMap.get(branch.getBranch().getActualBranchId());
            set = (Set)map.get(branch.getContext());
            f = set.remove(branch);
            if (removed && f) {
                this.removedBranchesF.add(branch);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveRootBranches.clear();
        this.toRemoveBranchesF.clear();
        this.toRemoveBranchesT.clear();
        return true;
    }
}

