/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.output;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputObserver
extends ExecutionObserver {
    private Map<Integer, Set<OutputCoverageGoal>> outputCoverage = new LinkedHashMap<Integer, Set<OutputCoverageGoal>>();
    private static final Logger logger = LoggerFactory.getLogger(OutputObserver.class);

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (statement instanceof MethodStatement) {
            MethodStatement methodStmt = (MethodStatement)statement;
            VariableReference varRef = methodStmt.getReturnValue();
            try {
                Object returnObject = varRef.getObject(scope);
                if (exception == null && !methodStmt.getReturnType().equals(Void.TYPE)) {
                    String className = methodStmt.getDeclaringClassName();
                    String methodDesc = methodStmt.getDescriptor();
                    String methodName = methodStmt.getMethodName();
                    this.outputCoverage.put(statement.getPosition(), OutputCoverageGoal.createGoalsFromObject(className, methodName, methodDesc, returnObject));
                }
            }
            catch (CodeUnderTestException codeUnderTestException) {
                // empty catch block
            }
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
        logger.debug("Adding returnValues map to ExecutionResult");
        r.setOutputGoals(this.outputCoverage);
    }

    @Override
    public void clear() {
        this.outputCoverage = new LinkedHashMap<Integer, Set<OutputCoverageGoal>>();
    }
}

