/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCoverageFactory
extends AbstractFitnessFactory<MethodCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(MethodCoverageFactory.class);

    @Override
    public List<MethodCoverageTestFitness> getCoverageGoals() {
        ArrayList<MethodCoverageTestFitness> goals = new ArrayList<MethodCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String className = Properties.TARGET_CLASS;
        Class<?> clazz = Properties.getTargetClassAndDontInitialise();
        if (clazz != null) {
            Class<?>[] innerClasses;
            goals.addAll(this.getCoverageGoals(clazz, className));
            for (Class<?> innerClass : innerClasses = clazz.getDeclaredClasses()) {
                String innerClassName = innerClass.getCanonicalName();
                goals.addAll(this.getCoverageGoals(innerClass, innerClassName));
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    private List<MethodCoverageTestFitness> getCoverageGoals(Class<?> clazz, String className) {
        Method[] allMethods;
        Constructor<?>[] allConstructors;
        ArrayList<MethodCoverageTestFitness> goals = new ArrayList<MethodCoverageTestFitness>();
        for (Constructor<?> c : allConstructors = clazz.getDeclaredConstructors()) {
            if (!TestUsageChecker.canUse(c)) continue;
            String methodName = "<init>" + Type.getConstructorDescriptor(c);
            logger.info("Adding goal for constructor " + className + "." + methodName);
            goals.add(new MethodCoverageTestFitness(className, methodName));
        }
        for (Method m : allMethods = clazz.getDeclaredMethods()) {
            if (!TestUsageChecker.canUse(m)) continue;
            if (clazz.isEnum() && (m.getName().equals("valueOf") || m.getName().equals("values") || m.getName().equals("ordinal"))) {
                logger.debug("Excluding valueOf for Enum " + m.toString());
                continue;
            }
            String methodName = m.getName() + Type.getMethodDescriptor(m);
            logger.info("Adding goal for method " + className + "." + methodName);
            goals.add(new MethodCoverageTestFitness(className, methodName));
        }
        return goals;
    }

    public static MethodCoverageTestFitness createMethodTestFitness(String className, String method) {
        return new MethodCoverageTestFitness(className, method.substring(method.lastIndexOf(".") + 1));
    }

    public static MethodCoverageTestFitness createMethodTestFitness(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return MethodCoverageFactory.createMethodTestFitness(instruction.getClassName(), instruction.getMethodName());
    }
}

