/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodCoverageFactory;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 3359321076367091582L;
    private static final Logger logger = LoggerFactory.getLogger(MethodCoverageSuiteFitness.class);
    protected final Map<String, TestFitnessFunction> methodCoverageMap = new LinkedHashMap<String, TestFitnessFunction>();
    protected final int totalMethods;
    private Set<String> toRemoveMethods = new LinkedHashSet<String>();
    private Set<String> removedMethods = new LinkedHashSet<String>();
    protected int maxCoveredMethods = 0;
    protected double bestFitness = Double.MAX_VALUE;

    public MethodCoverageSuiteFitness() {
        this.determineCoverageGoals();
        this.totalMethods = this.methodCoverageMap.size();
        logger.info("Total methods: " + this.totalMethods);
    }

    protected void determineCoverageGoals() {
        List<MethodCoverageTestFitness> goals = new MethodCoverageFactory().getCoverageGoals();
        for (MethodCoverageTestFitness goal : goals) {
            this.methodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
    }

    protected void handleConstructorExceptions(TestChromosome test, ExecutionResult result, Set<String> calledMethods) {
        if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions()) {
            return;
        }
        Integer exceptionPosition = result.getFirstPositionOfThrownException();
        Statement statement = result.test.getStatement(exceptionPosition);
        if (statement instanceof ConstructorStatement) {
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (this.methodCoverageMap.containsKey(name) && !calledMethods.contains(name)) {
                TestFitnessFunction goal = this.methodCoverageMap.get(name);
                test.getTestCase().addCoveredGoal(goal);
                calledMethods.add(name);
                this.toRemoveMethods.add(name);
                if (Properties.TEST_ARCHIVE) {
                    Archive.getArchiveInstance().updateArchive(goal, test, 0.0);
                }
            }
        }
    }

    protected boolean analyzeTraces(List<ExecutionResult> results, Set<String> calledMethods) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (String methodName : this.methodCoverageMap.keySet()) {
                TestFitnessFunction goal = this.methodCoverageMap.get(methodName);
                double fit = goal.getFitness(test, result);
                if (fit != 0.0) continue;
                calledMethods.add(methodName);
                this.toRemoveMethods.add(methodName);
            }
            this.handleConstructorExceptions(test, result, calledMethods);
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating method fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashSet<String> calledMethods = new LinkedHashSet<String>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, calledMethods);
        int coveredMethods = calledMethods.size() + this.removedMethods.size();
        int missingMethods = this.totalMethods - coveredMethods;
        assert (this.totalMethods == coveredMethods + missingMethods);
        fitness = 1.0 * (double)missingMethods;
        this.printStatusMessages(suite, this.totalMethods - missingMethods, fitness);
        if (this.totalMethods > 0) {
            suite.setCoverage(this, (double)coveredMethods / (double)this.totalMethods);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredMethods);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalMethods);
            fitness = this.totalMethods;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coveredMethods <= this.totalMethods) : "Covered " + coveredMethods + " vs total goals " + this.totalMethods;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredMethods == this.totalMethods) : "Fitness: " + fitness + ", coverage: " + coveredMethods + "/" + this.totalMethods;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    protected void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredMethods, double fitness) {
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (String method : this.toRemoveMethods) {
            TestFitnessFunction f = this.methodCoverageMap.remove(method);
            if (f != null) {
                this.removedMethods.add(method);
                continue;
            }
            throw new IllegalStateException("Goal to remove not found: " + method + ", candidates: " + this.methodCoverageMap.keySet());
        }
        this.toRemoveMethods.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        assert (this.totalMethods == this.methodCoverageMap.size() + this.removedMethods.size());
        return true;
    }
}

