/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.coverage.mutation.WeakMutationTestFitness;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testsuite.AbstractFitnessFactory;

public class MutationFactory
extends AbstractFitnessFactory<MutationTestFitness> {
    private boolean strong = true;
    private List<MutationTestFitness> goals = null;

    public MutationFactory() {
    }

    public MutationFactory(boolean strongMutation) {
        this.strong = strongMutation;
    }

    @Override
    public List<MutationTestFitness> getCoverageGoals() {
        return this.getCoverageGoals(null);
    }

    public List<MutationTestFitness> getCoverageGoals(String targetMethod) {
        if (this.goals != null) {
            return this.goals;
        }
        this.goals = new ArrayList<MutationTestFitness>();
        for (Mutation m : this.getMutantsLimitedPerClass()) {
            if (targetMethod != null && !m.getMethodName().endsWith(targetMethod)) continue;
            if (this.strong) {
                this.goals.add(new StrongMutationTestFitness(m));
                continue;
            }
            this.goals.add(new WeakMutationTestFitness(m));
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Mutants, this.goals.size());
        return this.goals;
    }

    private List<Mutation> getMutantsLimitedPerClass() {
        List<Mutation> mutants = MutationPool.getMutants();
        String[] operators = new String[]{"ReplaceVariable", "InsertUnaryOp", "ReplaceConstant", "ReplaceArithmeticOperator"};
        if (mutants.size() > Properties.MAX_MUTANTS_PER_CLASS) {
            for (String op : operators) {
                mutants.removeIf(u -> u.getMutationName().startsWith(op));
                if (mutants.size() < Properties.MAX_MUTANTS_PER_CLASS) break;
            }
        }
        return mutants;
    }
}

