/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.metaheuristics.StandardGA;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreederGA<T extends Chromosome>
extends StandardGA<T> {
    private final Logger logger = LoggerFactory.getLogger(BreederGA.class);

    public BreederGA(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        ArrayList<Object> newGeneration = new ArrayList<Object>();
        newGeneration.addAll(this.elitism());
        List candidates = this.population.subList(0, (int)((double)this.population.size() * Properties.TRUNCATION_RATE));
        if (candidates.size() <= 1) {
            candidates.addAll(this.population);
            AtMostOnceLogger.warn(this.logger, "Not sufficient candidates for reproduction, consider increasing the population size, or the truncation rate");
        }
        while (!this.isNextPopulationFull(newGeneration)) {
            Chromosome parent2;
            Chromosome parent1 = (Chromosome)Randomness.choice(candidates);
            if (parent1 == (parent2 = (Chromosome)Randomness.choice(candidates))) continue;
            Chromosome offspring1 = parent1.clone();
            Chromosome offspring2 = parent2.clone();
            try {
                this.crossoverFunction.crossOver(offspring1, offspring2);
            }
            catch (ConstructionFailedException e) {
                this.logger.info("CrossOver/Mutation failed.");
                continue;
            }
            Chromosome offspring = Randomness.choice(offspring1, offspring2);
            this.notifyMutation(offspring);
            offspring.mutate();
            if (offspring.isChanged()) {
                offspring.updateAge(this.currentIteration);
            }
            if (this.isTooLong(offspring)) continue;
            newGeneration.add(offspring1);
        }
        this.population = newGeneration;
        this.updateFitnessFunctionsAndValues();
        ++this.currentIteration;
    }
}

