/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIO<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = -5660970130698891194L;
    private static final Logger logger = LoggerFactory.getLogger(MIO.class);
    private final ChromosomeFactory<TestChromosome> randomFactory = new RandomLengthTestFactory();
    private double pr = Properties.P_RANDOM_TEST_OR_FROM_ARCHIVE;
    private int n = Properties.NUMBER_OF_TESTS_PER_TARGET;
    private TestSuiteChromosome solution = null;

    public MIO(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        if (this.solution == null || this.solution.getNumberOfMutations() >= Properties.MAX_NUM_MUTATIONS_BEFORE_GIVING_UP || this.solution.getNumberOfEvaluations() >= Properties.MAX_NUM_FITNESS_EVALUATIONS_BEFORE_GIVING_UP) {
            this.solution = new TestSuiteChromosome(this.randomFactory);
            Object test = null;
            if (Randomness.nextDouble() < this.pr) {
                test = this.randomFactory.getChromosome();
                if (((TestChromosome)test).size() == 0) {
                    test = Archive.getArchiveInstance().getSolution();
                }
            } else {
                test = Archive.getArchiveInstance().getSolution();
                if (test == null || ((TestChromosome)test).size() == 0) {
                    test = this.randomFactory.getChromosome();
                }
            }
            assert (test != null && ((TestChromosome)test).size() != 0);
            this.solution.addTest(test);
        }
        assert (this.solution != null);
        this.notifyMutation(this.solution);
        this.solution.mutate();
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(this.solution);
        }
        double usedBudget = this.progress();
        if (Double.compare(usedBudget, Properties.EXPLOITATION_STARTS_AT_PERCENT) >= 0) {
            this.pr = 0.0;
            this.n = 1;
        } else {
            double scale = usedBudget / Properties.EXPLOITATION_STARTS_AT_PERCENT;
            this.pr = Properties.P_RANDOM_TEST_OR_FROM_ARCHIVE - scale * Properties.P_RANDOM_TEST_OR_FROM_ARCHIVE;
            this.n = (int)Math.ceil((double)Properties.NUMBER_OF_TESTS_PER_TARGET - scale * (double)Properties.NUMBER_OF_TESTS_PER_TARGET);
            logger.debug("usedBudget: " + usedBudget + " | scale: " + scale + " | Pr: " + this.pr + " | N: " + this.n);
        }
        assert (this.pr >= 0.0);
        assert (this.n >= 1);
        Archive.getArchiveInstance().shrinkSolutions(this.n);
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        logger.debug("Set up initial population of size one");
        this.generateInitialPopulation(1);
        assert (this.population.size() == 1);
        this.solution = (TestSuiteChromosome)((Chromosome)this.population.get(0)).clone();
        this.calculateFitnessAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
            assert (!this.population.isEmpty()) : "Initial population is empty, i.e., EvoSuite could not create any test!";
        }
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        logger.debug("Starting evolution");
        while (!this.isFinished()) {
            this.evolve();
            if (this.shouldApplyLocalSearch()) {
                Set<TestChromosome> testsInArchive;
                if (Archive.getArchiveInstance().hasBeenUpdated() && !(testsInArchive = Archive.getArchiveInstance().getSolutions()).isEmpty()) {
                    TestSuiteChromosome individualInPopulation = (TestSuiteChromosome)this.population.get(0);
                    individualInPopulation.clearTests();
                    for (TestChromosome test : testsInArchive) {
                        individualInPopulation.addTest(test.getTestCase().clone());
                    }
                }
                this.applyLocalSearch();
            }
            logger.info("Updating fitness values");
            this.updateFitnessFunctionsAndValues();
            logger.info("Current iteration: " + this.currentIteration);
            this.notifyIteration();
        }
        TimeController.execute(this::updateBestIndividualFromArchive, "Update from archive", 5000L);
        this.notifySearchFinished();
    }
}

