/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.CrowdingComparator;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.comparators.SortByFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSGAII<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(NSGAII.class);
    private DominanceComparator dc = new DominanceComparator();

    public NSGAII(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        ArrayList<Chromosome> offspringPopulation = new ArrayList<Chromosome>(this.population.size());
        for (int i = 0; i < this.population.size() / 2; ++i) {
            Object parent1 = this.selectionFunction.select(this.population);
            Object parent2 = this.selectionFunction.select(this.population);
            Chromosome offspring1 = ((Chromosome)parent1).clone();
            Chromosome offspring2 = ((Chromosome)parent2).clone();
            try {
                if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
            }
            catch (Exception e) {
                logger.info("CrossOver failed");
            }
            if (Randomness.nextDouble() <= Properties.MUTATION_RATE) {
                this.notifyMutation(offspring1);
                offspring1.mutate();
                this.notifyMutation(offspring2);
                offspring2.mutate();
            }
            for (FitnessFunction<Chromosome> fitnessFunction : this.getFitnessFunctions()) {
                fitnessFunction.getFitness(offspring1);
                this.notifyEvaluation(offspring1);
                fitnessFunction.getFitness(offspring2);
                this.notifyEvaluation(offspring2);
            }
            offspringPopulation.add(offspring1);
            offspringPopulation.add(offspring2);
        }
        List union = this.union(this.population, offspringPopulation);
        List ranking = this.fastNonDominatedSort(union);
        int remain = this.population.size();
        int index = 0;
        List front = null;
        this.population.clear();
        front = ranking.get(index);
        while (remain > 0 && remain >= front.size()) {
            this.crowingDistanceAssignment(front);
            for (int k = 0; k < front.size(); ++k) {
                this.population.add(front.get(k));
            }
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = ranking.get(index);
        }
        if (remain > 0) {
            this.crowingDistanceAssignment(front);
            Collections.sort(front, new CrowdingComparator(true));
            for (int k = 0; k < remain; ++k) {
                this.population.add(front.get(k));
            }
            remain = 0;
        }
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        while (!this.isFinished()) {
            this.evolve();
            this.notifyIteration();
            this.writeIndividuals(this.population);
        }
        this.notifySearchFinished();
    }

    protected List<T> union(List<T> population, List<T> offspringPopulation) {
        int i;
        int newSize = population.size() + offspringPopulation.size();
        if (newSize < Properties.POPULATION) {
            newSize = Properties.POPULATION;
        }
        ArrayList<T> union = new ArrayList<T>(newSize);
        for (i = 0; i < population.size(); ++i) {
            union.add(population.get(i));
        }
        for (i = population.size(); i < population.size() + offspringPopulation.size(); ++i) {
            union.add(offspringPopulation.get(i - population.size()));
        }
        return union;
    }

    protected List<List<T>> fastNonDominatedSort(List<T> union) {
        int p;
        int i;
        int[] dominateMe = new int[union.size()];
        List[] iDominate = new List[union.size()];
        List[] front = new List[union.size() + 1];
        for (i = 0; i < front.length; ++i) {
            front[i] = new LinkedList();
        }
        for (p = 0; p < union.size(); ++p) {
            iDominate[p] = new LinkedList();
            dominateMe[p] = 0;
        }
        for (p = 0; p < union.size() - 1; ++p) {
            for (int q = p + 1; q < union.size(); ++q) {
                int flagDominate = this.dc.compare((Chromosome)union.get(p), (Chromosome)union.get(q));
                if (flagDominate == -1) {
                    iDominate[p].add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                iDominate[q].add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (p = 0; p < union.size(); ++p) {
            if (dominateMe[p] != 0) continue;
            front[0].add(p);
            ((Chromosome)union.get(p)).setRank(0);
        }
        i = 0;
        while (front[i].size() != 0) {
            Iterator it1 = front[++i - 1].iterator();
            while (it1.hasNext()) {
                Iterator it2 = iDominate[(Integer)it1.next()].iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    front[i].add(index);
                    ((Chromosome)union.get(index)).setRank(i);
                }
            }
        }
        ArrayList<List<T>> ranking = new ArrayList<List<T>>(i);
        for (int j = 0; j < i; ++j) {
            ArrayList<T> f = new ArrayList<T>(front[j].size());
            Iterator it1 = front[j].iterator();
            while (it1.hasNext()) {
                f.add(union.get((Integer)it1.next()));
            }
            ranking.add(f);
        }
        return ranking;
    }

    protected void crowingDistanceAssignment(List<T> f) {
        int size = f.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Chromosome)f.get(0)).setDistance(Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            ((Chromosome)f.get(0)).setDistance(Double.POSITIVE_INFINITY);
            ((Chromosome)f.get(1)).setDistance(Double.POSITIVE_INFINITY);
            return;
        }
        ArrayList<T> front = new ArrayList<T>(size);
        front.addAll(f);
        for (int i = 0; i < size; ++i) {
            ((Chromosome)front.get(i)).setDistance(0.0);
        }
        for (FitnessFunction ff : this.getFitnessFunctions()) {
            Collections.sort(front, new SortByFitness(ff, true));
            double objetiveMinn = ((Chromosome)front.get(0)).getFitness(ff);
            double objetiveMaxn = ((Chromosome)front.get(front.size() - 1)).getFitness(ff);
            ((Chromosome)front.get(0)).setDistance(Double.POSITIVE_INFINITY);
            ((Chromosome)front.get(size - 1)).setDistance(Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = ((Chromosome)front.get(j + 1)).getFitness(ff) - ((Chromosome)front.get(j - 1)).getFitness(ff);
                distance /= objetiveMaxn - objetiveMinn;
                ((Chromosome)front.get(j)).setDistance(distance += ((Chromosome)front.get(j)).getDistance());
            }
        }
    }
}

