/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.SortByFitness;

public class CrowdingDistance<T extends Chromosome> {
    protected void crowdingDistanceAssignment(List<T> front, Set<FitnessFunction<T>> set) {
        int size = front.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Chromosome)front.get(0)).setDistance(Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            ((Chromosome)front.get(0)).setDistance(Double.POSITIVE_INFINITY);
            ((Chromosome)front.get(1)).setDistance(Double.POSITIVE_INFINITY);
            return;
        }
        for (int i = 0; i < size; ++i) {
            ((Chromosome)front.get(i)).setDistance(0.0);
        }
        for (FitnessFunction<T> ff : set) {
            Collections.sort(front, new SortByFitness(ff, false));
            double objetiveMinn = ((Chromosome)front.get(0)).getFitness(ff);
            double objetiveMaxn = ((Chromosome)front.get(front.size() - 1)).getFitness(ff);
            ((Chromosome)front.get(0)).setDistance(Double.POSITIVE_INFINITY);
            ((Chromosome)front.get(size - 1)).setDistance(Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = ((Chromosome)front.get(j + 1)).getFitness(ff) - ((Chromosome)front.get(j - 1)).getFitness(ff);
                distance /= objetiveMaxn - objetiveMinn;
                ((Chromosome)front.get(j)).setDistance(distance += ((Chromosome)front.get(j)).getDistance());
            }
        }
    }

    public void subvectorDominanceAssignment(List<T> front, Set<FitnessFunction<T>> set) {
        int size = front.size();
        if (front.size() == 1) {
            ((Chromosome)front.get(0)).setDistance(Double.POSITIVE_INFINITY);
            return;
        }
        for (int i = 0; i < size; ++i) {
            ((Chromosome)front.get(i)).setDistance(Double.MAX_VALUE);
        }
        for (int i = 0; i < front.size() - 1; ++i) {
            Chromosome p1 = (Chromosome)front.get(i);
            for (int j = i + 1; j < front.size(); ++j) {
                Chromosome p2 = (Chromosome)front.get(j);
                int dominate1 = 0;
                int dominate2 = 0;
                for (FitnessFunction<T> ff : set) {
                    double value2;
                    double value1 = p1.getFitness(ff);
                    if (value1 < (value2 = p2.getFitness(ff))) {
                        ++dominate1;
                        continue;
                    }
                    if (!(value1 > value2)) continue;
                    ++dominate2;
                }
                p1.setDistance(Math.min((double)dominate1, p1.getDistance()));
                p2.setDistance(Math.min((double)dominate2, p2.getDistance()));
            }
        }
    }

    public void fastEpsilonDominanceAssignment(List<T> front, Set<FitnessFunction<T>> set) {
        for (Chromosome chromosome : front) {
            chromosome.setDistance(0.0);
        }
        for (FitnessFunction fitnessFunction : set) {
            double min = Double.POSITIVE_INFINITY;
            ArrayList<Chromosome> minSet = new ArrayList<Chromosome>(front.size());
            double max = 0.0;
            for (Chromosome test : front) {
                double value = test.getFitness(fitnessFunction);
                if (value < min) {
                    min = value;
                    minSet.clear();
                    minSet.add(test);
                } else if (value == min) {
                    minSet.add(test);
                }
                if (!(value > max)) continue;
                max = value;
            }
            if (max == min) continue;
            for (Chromosome test : minSet) {
                double numer = front.size() - minSet.size();
                double demon = front.size();
                test.setDistance(Math.max(test.getDistance(), numer / demon));
            }
        }
    }
}

