/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.comparators;

import java.util.Comparator;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;

public class MOSADominanceComparator<T extends Chromosome>
implements Comparator<Object> {
    private Set<FitnessFunction<T>> objectives;

    public MOSADominanceComparator(Set<FitnessFunction<T>> goals) {
        this.objectives = goals;
    }

    @Override
    public int compare(Object object1, Object object2) {
        if (object1 == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        Chromosome solution1 = (Chromosome)object1;
        Chromosome solution2 = (Chromosome)object2;
        boolean dominate1 = false;
        boolean dominate2 = false;
        for (FitnessFunction<T> entry : this.objectives) {
            double value2;
            double value1 = solution1.getFitness(entry);
            if (value1 < (value2 = solution2.getFitness(entry))) {
                dominate1 = true;
            } else if (value1 > value2) {
                dominate2 = true;
            }
            if (!dominate1 || !dominate2) continue;
            break;
        }
        if (dominate1 == dominate2) {
            return 0;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

