/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthStoppingCondition
extends StoppingConditionImpl {
    private static final Logger logger = LoggerFactory.getLogger(MaxLengthStoppingCondition.class);
    private static final long serialVersionUID = 8537667219135128366L;
    private double averageLength = 0.0;
    private int maxLength = Properties.MAX_LENGTH;

    @Override
    public boolean isFinished() {
        if (this.averageLength >= (double)this.maxLength) {
            logger.info("Maximum average length reached, stopping");
        }
        return this.averageLength >= (double)this.maxLength;
    }

    @Override
    public void reset() {
        this.averageLength = 0.0;
        this.maxLength = Properties.MAX_LENGTH;
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        double avg = 0.0;
        for (Chromosome c : algorithm.getPopulation()) {
            avg += (double)c.size();
        }
        this.averageLength = avg / (double)algorithm.getPopulation().size();
    }

    @Override
    public long getCurrentValue() {
        return (long)this.averageLength;
    }

    @Override
    public void setLimit(long limit) {
        this.maxLength = (int)limit;
    }

    @Override
    public long getLimit() {
        return (long)((double)this.maxLength + 0.5);
    }

    @Override
    public void forceCurrentValue(long value) {
    }
}

