/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cdg.ControlDependenceGraph;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBlock
implements Serializable,
Iterable<BytecodeInstruction> {
    private static final long serialVersionUID = -3465486470017841484L;
    private static Logger logger = LoggerFactory.getLogger(BasicBlock.class);
    private static int blockCount = 0;
    private int id = -1;
    protected ClassLoader classLoader;
    protected String className;
    protected String methodName;
    private Set<ControlDependency> controlDependencies;
    private Set<Integer> controlDependentBranchIDs;
    protected boolean isAuxiliaryBlock = false;
    private final List<BytecodeInstruction> instructions = new ArrayList<BytecodeInstruction>();

    public BasicBlock(ClassLoader classLoader, String className, String methodName, List<BytecodeInstruction> blockNodes) {
        if (className == null || methodName == null || blockNodes == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.classLoader = classLoader;
        this.setId();
        this.setInstructions(blockNodes);
        this.checkSanity();
    }

    protected BasicBlock(String className, String methodName) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.isAuxiliaryBlock = true;
    }

    public ControlDependenceGraph getCDG() {
        ControlDependenceGraph myCDG = GraphPool.getInstance(this.classLoader).getCDG(this.className, this.methodName);
        if (myCDG == null) {
            throw new IllegalStateException("expect GraphPool to know CDG for every method for which an instruction is known");
        }
        return myCDG;
    }

    public Set<Integer> getControlDependentBranchIds() {
        ControlDependenceGraph myDependence = this.getCDG();
        if (this.controlDependentBranchIDs == null) {
            this.controlDependentBranchIDs = myDependence.getControlDependentBranchIds(this);
            this.controlDependentBranchIDs = this.controlDependentBranchIDs.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.controlDependentBranchIDs;
    }

    public Set<ControlDependency> getControlDependencies() {
        if (this.controlDependencies == null) {
            this.controlDependencies = this.getCDG().getControlDependentBranches(this);
        }
        return this.controlDependencies;
    }

    public boolean hasControlDependenciesSet() {
        return this.controlDependencies != null;
    }

    private void setInstructions(List<BytecodeInstruction> blockNodes) {
        for (BytecodeInstruction instruction : blockNodes) {
            if (this.appendInstruction(instruction)) continue;
            throw new IllegalStateException("internal error while addind instruction to basic block list");
        }
        if (this.instructions.isEmpty()) {
            throw new IllegalStateException("expect each basic block to contain at least one instruction");
        }
    }

    private boolean appendInstruction(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.className.equals(instruction.getClassName())) {
            throw new IllegalArgumentException("expect elements of a basic block to be inside the same class");
        }
        if (!this.methodName.equals(instruction.getMethodName())) {
            throw new IllegalArgumentException("expect elements of a basic block to be inside the same class");
        }
        if (instruction.hasBasicBlockSet()) {
            throw new IllegalArgumentException("expect to get instruction without BasicBlock already set");
        }
        if (this.instructions.contains(instruction)) {
            throw new IllegalArgumentException("a basic block can not contain the same element twice");
        }
        instruction.setBasicBlock(this);
        return this.instructions.add(instruction);
    }

    private void setId() {
        this.id = ++blockCount;
    }

    public boolean containsInstruction(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return this.instructions.contains(instruction);
    }

    public boolean constainsInstruction(AbstractInsnNode insnNode) {
        for (BytecodeInstruction instruction : this.instructions) {
            if (!instruction.getASMNode().equals(insnNode)) continue;
            return true;
        }
        return false;
    }

    public BytecodeInstruction getFirstInstruction() {
        if (this.instructions.isEmpty()) {
            return null;
        }
        return this.instructions.get(0);
    }

    public BytecodeInstruction getLastInstruction() {
        if (this.instructions.isEmpty()) {
            return null;
        }
        return this.instructions.get(this.instructions.size() - 1);
    }

    public int getFirstLine() {
        for (BytecodeInstruction ins : this.instructions) {
            if (!ins.hasLineNumberSet()) continue;
            return ins.getLineNumber();
        }
        return -1;
    }

    public int getLastLine() {
        int r = -1;
        for (BytecodeInstruction ins : this.instructions) {
            if (!ins.hasLineNumberSet()) continue;
            r = ins.getLineNumber();
        }
        return r;
    }

    public String getName() {
        return (this.isAuxiliaryBlock ? "aux" : "") + "BasicBlock " + this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String explain() {
        StringBuilder r = new StringBuilder();
        r.append(this.getName() + ":\n");
        int i = 0;
        for (BytecodeInstruction instruction : this.instructions) {
            r.append("\t" + ++i + ")\t" + instruction.toString() + "\n");
        }
        return r.toString();
    }

    public String toString() {
        String r = "BB" + this.id;
        if (this.instructions.size() < 5) {
            for (BytecodeInstruction ins : this.instructions) {
                r = r.trim() + " " + ins.getInstructionType();
            }
        } else {
            r = r + " " + this.getFirstInstruction().getInstructionType() + " ... " + this.getLastInstruction().getInstructionType();
        }
        int startLine = this.getFirstLine();
        int endLine = this.getLastLine();
        r = r + " l" + (startLine == -1 ? "?" : startLine + "");
        r = r + "-l" + (endLine == -1 ? "?" : endLine + "");
        return r;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        result = 31 * result + (this.isAuxiliaryBlock ? 1231 : 1237);
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicBlock)) {
            return false;
        }
        BasicBlock other = (BasicBlock)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions)) {
            return false;
        }
        if (this.isEntryBlock() != other.isEntryBlock()) {
            return false;
        }
        return this.isExitBlock() == other.isExitBlock();
    }

    public void checkSanity() {
        logger.debug("checking sanity of " + this.toString());
    }

    public boolean isEntryBlock() {
        return false;
    }

    public boolean isExitBlock() {
        return false;
    }

    @Override
    public Iterator<BytecodeInstruction> iterator() {
        return this.instructions.iterator();
    }
}

