/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.List;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.BasicValue;

public class BooleanValueInterpreter
extends BasicInterpreter {
    public static final BasicValue BOOLEAN_VALUE = new BasicValue(Type.BOOLEAN_TYPE);
    public static final BasicValue BOOLEAN_ARRAY = new BasicValue(Type.getType("[Z"));
    private final boolean isStatic;
    private final Type[] types;

    public BooleanValueInterpreter(String desc, boolean isStatic) {
        this.types = Type.getArgumentTypes(desc);
        this.isStatic = isStatic;
    }

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 1: {
                return BOOLEAN_VALUE;
            }
            case 9: {
                if (type.getElementType() != Type.BOOLEAN_TYPE) break;
                return BOOLEAN_ARRAY;
            }
        }
        return super.newValue(type);
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 193) {
            return BOOLEAN_VALUE;
        }
        if (insn.getOpcode() == 180) {
            FieldInsnNode fieldNode = (FieldInsnNode)insn;
            if (BooleanTestabilityTransformation.isTransformedField(fieldNode.owner, fieldNode.name, fieldNode.desc)) {
                return BOOLEAN_VALUE;
            }
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        if (insn.getOpcode() == 3) {
            return BOOLEAN_VALUE;
        }
        if (insn.getOpcode() == 4) {
            return BOOLEAN_VALUE;
        }
        if (insn.getOpcode() == 178) {
            FieldInsnNode fieldNode = (FieldInsnNode)insn;
            if (BooleanTestabilityTransformation.isTransformedField(fieldNode.owner, fieldNode.name, fieldNode.desc)) {
                return BOOLEAN_VALUE;
            }
        }
        return super.newOperation(insn);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                if (value1 != BOOLEAN_ARRAY) break;
                return BOOLEAN_VALUE;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 21) {
            VarInsnNode varNode = (VarInsnNode)insn;
            if (this.isStatic ? varNode.var < this.types.length && this.types[varNode.var] == Type.BOOLEAN_TYPE : varNode.var > 0 && varNode.var - 1 < this.types.length && this.types[varNode.var - 1] == Type.BOOLEAN_TYPE) {
                return BOOLEAN_VALUE;
            }
        }
        return super.copyOperation(insn, value);
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn instanceof MethodInsnNode) {
            MethodInsnNode mi = (MethodInsnNode)insn;
            if (Type.getReturnType(BooleanTestabilityTransformation.getOriginalDesc(mi.owner, mi.name, mi.desc)) == Type.BOOLEAN_TYPE) {
                return BOOLEAN_VALUE;
            }
        }
        return super.naryOperation(insn, values);
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        if (v == BOOLEAN_VALUE && w == BasicValue.INT_VALUE) {
            return BasicValue.INT_VALUE;
        }
        if (w == BOOLEAN_VALUE && v == BasicValue.INT_VALUE) {
            return BasicValue.INT_VALUE;
        }
        return super.merge(v, w);
    }
}

