/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.ExceptionTransformationMethodAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionTransformationClassAdapter
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionTransformationClassAdapter.class);
    private String className;
    public static Map<String, Map<String, Set<Type>>> methodExceptionMap = new LinkedHashMap<String, Map<String, Set<Type>>>();

    public ExceptionTransformationClassAdapter(ClassVisitor cv, String className) {
        super(327680, cv);
        this.className = className;
        methodExceptionMap.put(className, new LinkedHashMap());
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            return mv;
        }
        if (name.equals("__STATIC_RESET")) {
            return mv;
        }
        if (!DependencyAnalysis.shouldInstrument(ResourceList.getClassNameFromResourcePath(this.className), name + desc)) {
            return mv;
        }
        logger.info("Applying exception transformation to " + this.className + ", method " + name + desc);
        return new ExceptionTransformationMethodAdapter(mv, this.className, name, access, desc);
    }
}

