/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.PackageInfo;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.shaded.org.objectweb.asm.Label;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineNumberMethodAdapter
extends MethodVisitor {
    private static Logger logger = LoggerFactory.getLogger(LineNumberMethodAdapter.class);
    private final String fullMethodName;
    private final String methodName;
    private final String className;
    private boolean hadInvokeSpecial = false;
    private List<Integer> skippedLines = new ArrayList<Integer>();
    int currentLine = 0;

    public LineNumberMethodAdapter(MethodVisitor mv, String className, String methodName, String desc) {
        super(327680, mv);
        this.fullMethodName = methodName + desc;
        this.className = className;
        this.methodName = methodName;
        if (!methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
        }
    }

    private void addLineNumberInstrumentation(int line) {
        LinePool.addLine(this.className, this.fullMethodName, line);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.fullMethodName);
        this.visitLdcInsn(line);
        this.mv.visitMethodInsn(184, PackageInfo.getNameWithSlash(ExecutionTracer.class), "passedLine", "(Ljava/lang/String;Ljava/lang/String;I)V", false);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        if (this.methodName.equals("<clinit>")) {
            return;
        }
        if (!this.hadInvokeSpecial) {
            this.skippedLines.add(line);
            return;
        }
        this.addLineNumberInstrumentation(line);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (opcode == 183 && this.methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
            for (int line : this.skippedLines) {
                this.addLineNumberInstrumentation(line);
            }
            this.skippedLines.clear();
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxNum = 3;
        super.visitMaxs(Math.max(maxNum, maxStack), maxLocals);
    }
}

