/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionChecker;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;
import org.evosuite.shaded.org.objectweb.asm.Label;
import org.evosuite.shaded.org.objectweb.asm.Type;

public class OverflowInstrumentation
extends ErrorBranchInstrumenter {
    private static final String CHECKER = ErrorConditionChecker.class.getCanonicalName().replace('.', '/');

    public OverflowInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    protected void insertBranchWithoutException(int opcode) {
        Label origTarget = new Label();
        this.mv.tagBranch();
        this.mv.visitJumpInsn(opcode, origTarget);
        this.mv.visitLabel(origTarget);
        this.mv.tagBranchExit();
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 96: 
            case 100: 
            case 104: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "underflowDistance", "(III)I", false);
                this.insertBranchWithoutException(157);
            }
            case 108: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "overflowDistance", "(III)I", false);
                this.insertBranchWithoutException(157);
                break;
            }
            case 98: 
            case 102: 
            case 106: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "underflowDistance", "(FFI)I", false);
                this.insertBranchWithoutException(156);
            }
            case 110: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "overflowDistance", "(FFI)I", false);
                this.insertBranchWithoutException(156);
                break;
            }
            case 99: 
            case 103: 
            case 107: {
                int loc = this.mv.newLocal(Type.DOUBLE_TYPE);
                this.mv.storeLocal(loc);
                this.mv.visitInsn(92);
                this.mv.loadLocal(loc);
                this.mv.visitInsn(94);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "underflowDistance", "(DDI)I", false);
                this.insertBranchWithoutException(156);
            }
            case 111: {
                int loc = this.mv.newLocal(Type.DOUBLE_TYPE);
                this.mv.storeLocal(loc);
                this.mv.visitInsn(92);
                this.mv.loadLocal(loc);
                this.mv.visitInsn(94);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "overflowDistance", "(DDI)I", false);
                this.insertBranchWithoutException(156);
                break;
            }
            case 97: 
            case 101: 
            case 105: {
                int loc2 = this.mv.newLocal(Type.LONG_TYPE);
                this.mv.storeLocal(loc2);
                this.mv.visitInsn(92);
                this.mv.loadLocal(loc2);
                this.mv.visitInsn(94);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "underflowDistance", "(JJI)I", false);
                this.insertBranchWithoutException(156);
            }
            case 109: {
                int loc2 = this.mv.newLocal(Type.LONG_TYPE);
                this.mv.storeLocal(loc2);
                this.mv.visitInsn(92);
                this.mv.loadLocal(loc2);
                this.mv.visitInsn(94);
                this.mv.visitLdcInsn(opcode);
                this.mv.visitMethodInsn(184, CHECKER, "overflowDistance", "(JJI)I", false);
                this.insertBranchWithoutException(156);
            }
        }
    }
}

