/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;

public class QueueInstrumentation
extends ErrorBranchInstrumenter {
    private static final String LISTNAME = Queue.class.getCanonicalName().replace('.', '/');
    private final List<String> emptyListMethods = Arrays.asList("remove", "element");

    public QueueInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (owner.equals(LISTNAME) && this.emptyListMethods.contains(name)) {
            Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
            this.tagBranchStart();
            this.mv.visitMethodInsn(182, LISTNAME, "isEmpty", "()Z", false);
            this.insertBranchWithoutTag(158, "java/util/NoSuchElementException");
            this.tagBranchEnd();
            this.restoreMethodParameters(tempVariables, desc);
        }
    }
}

