/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.io.File;
import org.evosuite.Properties;
import org.evosuite.utils.FileIOUtils;

public class CoverageReportGenerator {
    public static void writeCoverage(boolean[][] coverage, Properties.Criterion criterion) {
        StringBuilder suite = new StringBuilder();
        for (int i = 0; i < coverage.length; ++i) {
            StringBuilder test = new StringBuilder();
            for (int j = 0; j < coverage[i].length - 1; ++j) {
                if (coverage[i][j]) {
                    test.append("1 ");
                    continue;
                }
                test.append("0 ");
            }
            if (!test.toString().contains("1")) continue;
            if (coverage[i][coverage[i].length - 1]) {
                test.append("+\n");
            } else {
                test.append("-\n");
            }
            suite.append((CharSequence)test);
        }
        FileIOUtils.writeFile(suite.toString(), new File(CoverageReportGenerator.getReportDir().getAbsolutePath() + File.separator + "data" + File.separator + Properties.TARGET_CLASS + File.separator + criterion.toString() + File.separator + Properties.COVERAGE_MATRIX_FILENAME));
    }

    private static File getReportDir() throws RuntimeException {
        File dir = new File(Properties.REPORT_DIR);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create report dir: " + Properties.REPORT_DIR);
        }
        return dir;
    }
}

