/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.instrumentation.NonInstrumentingClassLoader;
import org.evosuite.junit.JUnitExecutionException;
import org.evosuite.junit.JUnitFailure;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.JUnitResultBuilder;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.classhandling.JDKClassResetter;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.util.JarPathing;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.evosuite.testcase.TestCase;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitAnalyzer {
    private static Logger logger = LoggerFactory.getLogger(JUnitAnalyzer.class);
    private static int dirCounter = 0;
    private static final String JAVA = ".java";
    private static final String CLASS = ".class";
    private static NonInstrumentingClassLoader loader = new NonInstrumentingClassLoader();
    private static int NUM = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTestsThatDoNotCompile(List<TestCase> tests) {
        logger.info("Going to execute: removeTestsThatDoNotCompile");
        if (tests == null || tests.isEmpty()) {
            return;
        }
        Iterator<TestCase> iter = tests.iterator();
        while (iter.hasNext() && TimeController.getInstance().hasTimeToExecuteATestCase()) {
            TestCase test = iter.next();
            File dir = JUnitAnalyzer.createNewTmpDir();
            if (dir == null) {
                logger.warn("Failed to create tmp dir");
                return;
            }
            logger.debug("Created tmp folder: " + dir.getAbsolutePath());
            try {
                ArrayList<TestCase> singleList = new ArrayList<TestCase>();
                singleList.add(test);
                List<File> generated = JUnitAnalyzer.compileTests(singleList, dir);
                if (generated != null) continue;
                iter.remove();
                String code = test.toCode();
                logger.error("Failed to compile test case:\n" + code);
            }
            finally {
                if (dir == null) continue;
                try {
                    FileUtils.deleteDirectory(dir);
                    logger.debug("Deleted tmp folder: " + dir.getAbsolutePath());
                }
                catch (Exception e) {
                    logger.error("Cannot delete tmp dir: " + dir.getAbsolutePath(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int handleTestsThatAreUnstable(List<TestCase> tests) {
        int numUnstable = 0;
        logger.info("Going to execute: handleTestsThatAreUnstable");
        if (tests == null || tests.isEmpty()) {
            return numUnstable;
        }
        File dir = JUnitAnalyzer.createNewTmpDir();
        if (dir == null) {
            logger.error("Failed to create tmp dir");
            return numUnstable;
        }
        logger.debug("Created tmp folder: " + dir.getAbsolutePath());
        try {
            List<File> generated = JUnitAnalyzer.compileTests(tests, dir);
            if (generated == null) {
                logger.warn("Failed to compile the test cases ");
                int n = numUnstable;
                return n;
            }
            if (!TimeController.getInstance().hasTimeToExecuteATestCase()) {
                logger.error("Ran out of time while checking tests");
                int n = numUnstable;
                return n;
            }
            loader = new NonInstrumentingClassLoader();
            Class<?>[] testClasses = JUnitAnalyzer.loadTests(generated);
            if (testClasses == null) {
                logger.error("Found no classes for compiled tests");
                int e = numUnstable;
                return e;
            }
            JUnitResult result = JUnitAnalyzer.runTests(testClasses, dir);
            if (result.wasSuccessful()) {
                int n = numUnstable;
                return n;
            }
            block26: for (JUnitFailure failure : result.getFailures()) {
                String testName = failure.getDescriptionMethodName();
                for (int i = 0; i < tests.size(); ++i) {
                    if (!TestSuiteWriterUtils.getNameOfTest(tests, i).equals(testName) || !tests.get(i).isFailing()) continue;
                    logger.info("Failure is expected, continuing...");
                    continue block26;
                }
                if (testName == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Issue in scaffolding of the test suite: " + failure.getMessage() + "\n");
                    sb.append("Stack trace:\n");
                    for (String elem : failure.getExceptionStackTrace()) {
                        sb.append(elem + "\n");
                    }
                    logger.error(sb.toString());
                    numUnstable = tests.size();
                    tests.clear();
                    int n = numUnstable;
                    return n;
                }
                if (testName.equals("initializationError") && failure.getMessage().contains("Failed to attach Java Agent")) {
                    logger.warn("Likely error with EvoSuite instrumentation, ignoring failure in test execution");
                    continue;
                }
                logger.warn("Found unstable test named " + testName + " -> " + failure.getExceptionClassName() + ": " + failure.getMessage());
                for (String elem : failure.getExceptionStackTrace()) {
                    logger.info(elem);
                }
                boolean toRemove = !failure.isAssertionError();
                for (int i = 0; i < tests.size(); ++i) {
                    if (!TestSuiteWriterUtils.getNameOfTest(tests, i).equals(testName)) continue;
                    logger.warn("Failing test:\n " + tests.get(i).toCode());
                    ++numUnstable;
                    if (!toRemove) {
                        logger.debug("Going to mark test as unstable: " + testName);
                        tests.get(i).setUnstable(true);
                        continue block26;
                    }
                    logger.debug("Going to remove unstable test: " + testName);
                    tests.remove(i);
                    continue block26;
                }
            }
        }
        catch (Exception e) {
            logger.error("" + e, e);
            int n = numUnstable;
            return n;
        }
        finally {
            if (dir != null) {
                try {
                    FileUtils.deleteDirectory(dir);
                }
                catch (Exception e) {
                    logger.warn("Cannot delete tmp dir: " + dir.getName(), e);
                }
            }
        }
        return numUnstable;
    }

    private static JUnitResult runTests(Class<?>[] testClasses, File testClassDir) throws JUnitExecutionException {
        return JUnitAnalyzer.runJUnitOnCurrentProcess(testClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JUnitResult runJUnitOnCurrentProcess(Class<?>[] testClasses) {
        JUnitCore runner = new JUnitCore();
        boolean wasSandboxOn = Sandbox.isSecurityManagerInitialized();
        Set<Thread> privileged = null;
        if (wasSandboxOn) {
            privileged = Sandbox.resetDefaultSecurityManager();
        }
        Result result = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            TestGenerationContext.getInstance().goingToExecuteSUTCode();
            Thread.currentThread().setContextClassLoader(testClasses[0].getClassLoader());
            JDKClassResetter.reset();
            result = runner.run(testClasses);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
            TestGenerationContext.getInstance().doneWithExecutingSUTCode();
        }
        if (wasSandboxOn) {
            if (!Sandbox.isSecurityManagerInitialized()) {
                Sandbox.initializeSecurityManagerForSUT(privileged);
            }
        } else if (Sandbox.isSecurityManagerInitialized()) {
            logger.warn("EvoSuite problem: tests set up a security manager, but they do not remove it after execution");
            Sandbox.resetDefaultSecurityManager();
        }
        JUnitResultBuilder builder = new JUnitResultBuilder();
        JUnitResult junitResult = builder.build(result);
        return junitResult;
    }

    public static boolean isJavaCompilerAvailable() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        return compiler != null;
    }

    private static List<File> compileTests(List<TestCase> tests, File dir) {
        TestSuiteWriter suite = new TestSuiteWriter();
        suite.insertAllTests(tests);
        int beginIndex = Properties.TARGET_CLASS.lastIndexOf(".") + 1;
        String name = Properties.TARGET_CLASS.substring(beginIndex);
        name = name + "_" + NUM++ + "_tmp_" + Properties.JUNIT_SUFFIX;
        try {
            String targetProjectCP;
            List<File> generated = suite.writeTestSuite(name, dir.getAbsolutePath(), Collections.EMPTY_LIST);
            for (File file : generated) {
                if (file.exists()) continue;
                logger.error("Supposed to generate " + file + " but it does not exist");
                return null;
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                logger.error("No Java compiler is available");
                return null;
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            Locale locale = Locale.getDefault();
            Charset charset = Charset.forName("UTF-8");
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, locale, charset);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(generated);
            ArrayList<String> optionList = new ArrayList<String>();
            String evosuiteCP = ClassPathHandler.getInstance().getEvoSuiteClassPath();
            if (JarPathing.containsAPathingJar(evosuiteCP)) {
                evosuiteCP = JarPathing.expandPathingJars(evosuiteCP);
            }
            if (JarPathing.containsAPathingJar(targetProjectCP = ClassPathHandler.getInstance().getTargetProjectClasspath())) {
                targetProjectCP = JarPathing.expandPathingJars(targetProjectCP);
            }
            String classpath = targetProjectCP + File.pathSeparator + evosuiteCP;
            optionList.addAll(Arrays.asList("-classpath", classpath));
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
            boolean compiled = task.call();
            fileManager.close();
            if (!compiled) {
                logger.error("Compilation failed on compilation units: " + compilationUnits);
                logger.error("Classpath: " + classpath);
                logger.error("evosuiteCP: " + evosuiteCP);
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    if (diagnostic.getMessage(null).startsWith("error while writing")) {
                        logger.error("Error is due to file permissions, ignoring...");
                        return generated;
                    }
                    logger.error("Diagnostic: " + diagnostic.getMessage(null) + ": " + diagnostic.getLineNumber());
                }
                StringBuffer buffer = new StringBuffer();
                for (JavaFileObject javaFileObject : compilationUnits) {
                    List<String> lines = FileUtils.readLines(new File(javaFileObject.toUri().getPath()));
                    buffer.append(compilationUnits.iterator().next().toString() + "\n");
                    for (int i = 0; i < lines.size(); ++i) {
                        buffer.append(i + 1 + ": " + lines.get(i) + "\n");
                    }
                }
                logger.error(buffer.toString());
                return null;
            }
            return generated;
        }
        catch (IOException e) {
            logger.error("" + e, e);
            return null;
        }
    }

    protected static File createNewTmpDir() {
        File dir = null;
        String dirName = FileUtils.getTempDirectoryPath() + File.separator + "EvoSuite_" + dirCounter++ + "_" + System.currentTimeMillis();
        dir = new File(dirName);
        if (!dir.mkdirs()) {
            logger.error("Cannot create tmp dir: " + dirName);
            return null;
        }
        if (!dir.exists()) {
            logger.error("Weird behavior: we created folder, but Java cannot determine if it exists? Folder: " + dirName);
            return null;
        }
        return dir;
    }

    private static Class<?>[] loadTests(List<File> tests) {
        Class<?>[] testClasses = JUnitAnalyzer.getClassesFromFiles(tests);
        List<File> otherClasses = JUnitAnalyzer.listOnlyFiles(tests);
        JUnitAnalyzer.getClassesFromFiles(otherClasses);
        return testClasses;
    }

    private static List<File> listOnlyFiles(List<File> tests) throws IllegalArgumentException {
        if (tests == null || tests.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        File parentFolder = tests.get(0).getParentFile();
        for (File file : tests) {
            if (!file.getParentFile().equals(parentFolder)) {
                throw new IllegalArgumentException("Tests file are not in the same folder");
            }
            classNames.add(JUnitAnalyzer.removeFileExtension(file.getName()));
        }
        LinkedList<File> otherClasses = new LinkedList<File>();
        for (File file : parentFolder.listFiles()) {
            String name = JUnitAnalyzer.removeFileExtension(file.getName());
            if (classNames.contains(name)) continue;
            classNames.add(name);
            otherClasses.add(file);
        }
        return otherClasses;
    }

    private static String removeFileExtension(String str) {
        if (str == null) {
            return null;
        }
        int pos = str.lastIndexOf(".");
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyCompilationAndExecution(List<TestCase> tests) {
        if (tests == null || tests.isEmpty()) {
            return true;
        }
        File dir = JUnitAnalyzer.createNewTmpDir();
        if (dir == null) {
            logger.warn("Failed to create tmp dir");
            return false;
        }
        try {
            List<File> generated = JUnitAnalyzer.compileTests(tests, dir);
            if (generated == null) {
                logger.warn("Failed to compile the test cases ");
                boolean bl = false;
                return bl;
            }
            Class<?>[] testClasses = JUnitAnalyzer.loadTests(generated);
            if (testClasses == null) {
                logger.error("Found no classes for compiled tests");
                boolean e = false;
                return e;
            }
            JUnitResult result = JUnitAnalyzer.runTests(testClasses, dir);
            if (!result.wasSuccessful()) {
                logger.error("" + result.getFailureCount() + " test cases failed");
                for (JUnitFailure failure : result.getFailures()) {
                    logger.error("Failure " + failure.getExceptionClassName() + ": " + failure.getMessage() + "\n" + failure.getTrace());
                }
                boolean bl = false;
                return bl;
            }
            if (result.getRunCount() == 0) {
                logger.warn("There was no test to run");
            }
        }
        catch (Exception e) {
            logger.error("" + e, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (dir != null) {
                try {
                    FileUtils.deleteDirectory(dir);
                }
                catch (IOException e) {
                    logger.warn("Cannot delete tmp dir: " + dir.getName(), e);
                }
            }
        }
        logger.debug("Successfully compiled and run test cases generated for " + Properties.TARGET_CLASS);
        return true;
    }

    private static Class<?>[] getClassesFromFiles(Collection<File> files) {
        for (File file : files) {
            if (!JUnitAnalyzer.isScaffolding(file)) continue;
            JUnitAnalyzer.loadClass(file);
        }
        ArrayList classes = new ArrayList();
        for (File file : files) {
            Class<?> clazz;
            if (JUnitAnalyzer.isScaffolding(file) || (clazz = JUnitAnalyzer.loadClass(file)) == null) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static boolean isScaffolding(File file) {
        String name = file.getName();
        return name.endsWith("_" + Properties.SCAFFOLDING_SUFFIX + JAVA) || name.endsWith("_" + Properties.SCAFFOLDING_SUFFIX + CLASS);
    }

    private static Class<?> loadClass(File file) {
        String name;
        if (!file.isFile()) {
            return null;
        }
        String packagePrefix = Properties.CLASS_PREFIX;
        if (!packagePrefix.isEmpty() && !packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        if (!(name = file.getName()).endsWith(JAVA) && !name.endsWith(CLASS)) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        if (name.endsWith(JAVA)) {
            name = name.substring(0, name.length() - JAVA.length());
            fileName = fileName.substring(0, fileName.length() - JAVA.length()) + CLASS;
        } else {
            assert (name.endsWith(CLASS));
            name = name.substring(0, name.length() - CLASS.length());
        }
        String className = packagePrefix + name;
        Class<?> testClass = null;
        try {
            logger.info("Loading class " + className);
            testClass = loader.loadClassFromFile(className, fileName);
        }
        catch (ClassNotFoundException e) {
            logger.error("Failed to load test case " + className + " from file " + file.getAbsolutePath() + " , error " + e, e);
        }
        return testClass;
    }
}

