/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.rules;

import java.util.Arrays;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.junit.rules.BaseRule;
import org.evosuite.runtime.classhandling.ClassResetter;

public class StaticStateResetter
extends BaseRule {
    private String[] classNames;

    public StaticStateResetter(String ... classesToReset) {
        this.classNames = Arrays.copyOf(classesToReset, classesToReset.length);
        Properties.RESET_STATIC_FIELDS = true;
        ClassResetter.getInstance().setClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
    }

    @Override
    protected void before() {
    }

    @Override
    protected void after() {
        for (int i = 0; i < this.classNames.length; ++i) {
            String classNameToReset = this.classNames[i];
            try {
                ClassResetter.getInstance().reset(classNameToReset);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

