/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.lm;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.evosuite.Properties;
import org.evosuite.lm.Chromosome;
import org.evosuite.lm.EvaluationBudgetExpendedException;
import org.evosuite.lm.LangModel;
import org.evosuite.lm.MutationType;
import org.evosuite.testcase.ValueMinimizer;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageModelSearch
implements Comparator<Chromosome> {
    protected static final int GENERATIONS = 1000000;
    private static Logger logger = LoggerFactory.getLogger(LanguageModelSearch.class);
    protected final LangModel languageModel;
    protected final String startPoint;
    protected final ValueMinimizer.Minimization objective;
    protected final ConstantValue constantValue;
    protected static final int MAX_EVALUATIONS = Properties.LM_ITERATIONS;
    private int evaluations = 0;

    public int getEvaluations() {
        return this.evaluations;
    }

    public LanguageModelSearch(ValueMinimizer.Minimization objective, ConstantValue constantValue) {
        try {
            this.languageModel = new LangModel(Properties.LM_SRC);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create language model");
        }
        this.startPoint = (String)constantValue.getValue();
        this.objective = objective;
        this.constantValue = constantValue;
    }

    public static String mutateRandom(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        int position = (int)Math.abs(Randomness.nextDouble() * (double)input.length());
        String output = input.substring(0, position);
        int tailSize = input.length() - position;
        assert (tailSize >= 0);
        int replacementSize = 1;
        if (tailSize > 1) {
            replacementSize = Randomness.nextInt(1, tailSize);
        }
        String replacementString = "";
        for (int i = 0; i < replacementSize; ++i) {
            replacementString = replacementString + (char)Randomness.nextInt(32, 127);
        }
        output = output + replacementString;
        output = output + input.substring(position + replacementSize);
        return output;
    }

    public static String mutateEvoSuite(String input) {
        char[] array = input.toCharArray();
        for (int index = 0; index < input.length(); ++index) {
            if (!(Randomness.nextDouble() < 1.0 / (0.5 * (double)input.length() + 1.0))) continue;
            char oldValue = array[index];
            while (array[index] == oldValue) {
                array[index] = (char)Randomness.nextInt(32, 127);
            }
        }
        assert (String.valueOf(array).length() == input.length());
        return String.valueOf(array);
    }

    public String mutate(String input) {
        if (Properties.LM_MUTATION_TYPE == MutationType.LANGMODEL) {
            return this.mutateLangModel(input);
        }
        if (Properties.LM_MUTATION_TYPE == MutationType.RANDOM) {
            return LanguageModelSearch.mutateRandom(input);
        }
        if (Properties.LM_MUTATION_TYPE == MutationType.EVOSUITE) {
            return LanguageModelSearch.mutateEvoSuite(input);
        }
        throw new RuntimeException("Mutation type " + (Object)((Object)Properties.LM_MUTATION_TYPE) + " not supported");
    }

    public String generateRandomStringFromModel(int maxStringLength, String previousChar) {
        String newString = "";
        do {
            String nextChar;
            HashSet<Integer> choices = new HashSet<Integer>();
            choices.addAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
            boolean foundValidChar = false;
            do {
                int currentChoice = (Integer)Randomness.choice(choices);
                choices.remove(currentChoice);
                nextChar = previousChar == null ? this.languageModel.predict_char(currentChoice) : this.languageModel.predict_char(previousChar, currentChoice);
                boolean bl = foundValidChar = nextChar != null && !this.languageModel.isMagicChar(nextChar);
            } while (!choices.isEmpty() && !foundValidChar);
            if (!foundValidChar) {
                logger.debug("Couldn't find any bigram or unigram for " + previousChar);
                nextChar = "a";
            }
            if (!this.languageModel.isEndOfSentence(nextChar)) {
                newString = newString + nextChar;
            }
            previousChar = nextChar;
        } while (newString.length() < maxStringLength && !this.languageModel.isEndOfSentence(previousChar));
        return newString;
    }

    public String generateRandomStringFromModelWithExactLength(int targetStringLength, String previousChar) {
        String newString = this.generateRandomStringFromModel(targetStringLength, previousChar);
        while (newString.length() < targetStringLength) {
            newString = newString + this.generateRandomStringFromModel(targetStringLength - newString.length(), newString.charAt(newString.length() - 1) + "");
        }
        assert (newString.length() == targetStringLength);
        return newString;
    }

    public String generateRandomStringFromModelWithExactLength(int targetStringLength) {
        return this.generateRandomStringFromModelWithExactLength(targetStringLength, null);
    }

    public String generateRandomStringFromModel(int maxStringLength) {
        return this.generateRandomStringFromModel(maxStringLength, null);
    }

    public String mutateLangModel(String input) {
        if (input.length() == 0) {
            return input;
        }
        int startPoint = (int)(Randomness.nextDouble() * (double)input.length());
        int remainingLength = (int)Math.round(Randomness.nextDouble() * (double)(input.length() - startPoint));
        if (remainingLength == 0) {
            return input;
        }
        String output = input.substring(0, startPoint);
        String replacementChunk = this.generateRandomStringFromModelWithExactLength(remainingLength, "" + input.charAt(startPoint));
        output = output + replacementChunk;
        output = output + input.substring(startPoint + remainingLength, input.length());
        return output;
    }

    protected double evaluate(Chromosome individual) throws EvaluationBudgetExpendedException {
        if (this.isBudgetExpended()) {
            throw new EvaluationBudgetExpendedException();
        }
        ++this.evaluations;
        String oldValue = (String)this.constantValue.getValue();
        this.constantValue.setValue(individual.getValue());
        boolean isNotWorse = this.objective.isNotWorse();
        this.constantValue.setValue(oldValue);
        return (double)(isNotWorse ? 1 : 0) + this.languageModel.score(individual.getValue());
    }

    protected boolean isBudgetExpended() {
        return this.evaluations >= MAX_EVALUATIONS;
    }

    protected Chromosome mutate(Chromosome individual) {
        assert (individual != null);
        return new Chromosome(this.mutate(individual.getValue()));
    }

    public abstract String optimise();

    @Override
    public int compare(Chromosome o1, Chromosome o2) {
        if (!o1.isEvaluated()) {
            o1.setFitness(this.evaluate(o1));
        }
        if (!o2.isEvaluated()) {
            o2.setFitness(this.evaluate(o2));
        }
        return o1.compareTo(o2);
    }

    protected void resetEvaluationCounter() {
        this.evaluations = 0;
    }
}

