/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import dk.brics.automaton.RegExp;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.evosuite.PackageInfo;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;

public class RegressionExceptionHelper {
    private static final List<Class<?>> INVALID_EXCEPTIONS = Arrays.asList(StackOverflowError.class, AssertionError.class);

    public static String simpleExceptionName(RegressionTestChromosome test, Integer statementPos, Throwable ex) {
        Statement exThrowingStatement;
        if (ex == null) {
            return "";
        }
        String exception = ex.getClass().getSimpleName();
        if (test.getTheTest().getTestCase().hasStatement(statementPos) && (exThrowingStatement = test.getTheTest().getTestCase().getStatement(statementPos)) instanceof MethodStatement) {
            String exMethodcall = ((MethodStatement)exThrowingStatement).getMethod().getName();
            exception = exMethodcall + ":" + exception;
        }
        return exception;
    }

    public static String getExceptionSignature(Throwable throwable, String CUT2) {
        StackTraceElement[] stackTrace;
        String signature = throwable.getClass().getSimpleName();
        for (StackTraceElement el : stackTrace = throwable.getStackTrace()) {
            String elClass = el.getClassName();
            if (!Objects.equals(elClass, CUT2)) continue;
            String method = el.getMethodName();
            int line = el.getLineNumber();
            signature = signature + ":" + method + "-" + line;
            break;
        }
        return signature;
    }

    public static int compareExceptionDiffs(Map<Integer, Throwable> originalExceptionMapping, Map<Integer, Throwable> regressionExceptionMapping) {
        int exDiff = Math.abs(originalExceptionMapping.size() - regressionExceptionMapping.size());
        if (exDiff == 0) {
            for (Map.Entry<Integer, Throwable> origException : originalExceptionMapping.entrySet()) {
                String regExceptionMessage;
                String origExceptionMessage;
                int diffIndex;
                boolean skip;
                block16: {
                    block15: {
                        skip = false;
                        try {
                            if (origException.getValue() != null && origException.getValue().getMessage() != null) break block15;
                            originalExceptionMapping.remove(origException.getKey());
                            skip = true;
                        }
                        catch (Throwable t) {
                            continue;
                        }
                    }
                    try {
                        Throwable otherX;
                        String otherSourceClass;
                        Throwable x = origException.getValue();
                        Class<?> ex = RegressionExceptionHelper.getExceptionClassToUse(x);
                        String sourceClass = RegressionExceptionHelper.getSourceClassName(x);
                        if (sourceClass != null && RegressionExceptionHelper.isValidSource(sourceClass) && RegressionExceptionHelper.isExceptionToAssertValid(ex) && !sourceClass.equals(otherSourceClass = RegressionExceptionHelper.getSourceClassName(otherX = regressionExceptionMapping.get(origException.getKey())))) {
                            ++exDiff;
                        }
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    try {
                        if (!regressionExceptionMapping.containsKey(origException.getKey()) || regressionExceptionMapping.get(origException.getKey()) != null && regressionExceptionMapping.get(origException.getKey()).getMessage() != null) break block16;
                        regressionExceptionMapping.remove(origException.getKey());
                        skip = true;
                    }
                    catch (Throwable t) {
                        continue;
                    }
                }
                if (!skip && regressionExceptionMapping.get(origException.getKey()) != null && (diffIndex = StringUtils.indexOfDifference((CharSequence)(origExceptionMessage = origException.getValue().getMessage()), (CharSequence)(regExceptionMessage = regressionExceptionMapping.get(origException.getKey()).getMessage()))) > 0) {
                    if (origExceptionMessage.charAt(diffIndex - 1) == '@') {
                        originalExceptionMapping.remove(origException.getKey());
                        regressionExceptionMapping.remove(origException.getKey());
                        skip = true;
                    } else {
                        String last10;
                        int howFarBack = 10;
                        if (diffIndex > howFarBack && (last10 = origExceptionMessage.substring(diffIndex - howFarBack, diffIndex)).contains("@")) {
                            originalExceptionMapping.remove(origException.getKey());
                            regressionExceptionMapping.remove(origException.getKey());
                            skip = true;
                        }
                    }
                }
                if (!skip && origException.getValue().getMessage().contains("Security manager blocks")) {
                    originalExceptionMapping.remove(origException.getKey());
                    regressionExceptionMapping.remove(origException.getKey());
                    skip = true;
                }
                if (skip || regressionExceptionMapping.containsKey(origException.getKey()) && regressionExceptionMapping.get(origException.getKey()).getMessage().equals(origException.getValue().getMessage())) continue;
                ++exDiff;
            }
            for (Map.Entry<Integer, Throwable> regException : regressionExceptionMapping.entrySet()) {
                if (originalExceptionMapping.containsKey(regException.getKey())) continue;
                ++exDiff;
            }
        }
        return exDiff;
    }

    public static void addExceptionAssertionComments(RegressionTestChromosome regressionTest, Map<Integer, Throwable> originalExceptionMapping, Map<Integer, Throwable> regressionExceptionMapping) {
        for (Map.Entry<Integer, Throwable> original : originalExceptionMapping.entrySet()) {
            int originalStatementPos = original.getKey();
            Throwable originalException = original.getValue();
            if (!regressionExceptionMapping.containsKey(originalStatementPos)) {
                if (!RegressionExceptionHelper.testStatementCommentNotContains(regressionTest, originalStatementPos, "modified version")) continue;
                RegressionExceptionHelper.addExceptionDifferenceComment(regressionTest, originalException, originalStatementPos, "The modified version did not exhibit this exception", false);
                continue;
            }
            if (originalException != null && originalException.getMessage() != null) {
                if (!originalException.getMessage().equals(regressionExceptionMapping.get(originalStatementPos).getMessage())) {
                    if (RegressionExceptionHelper.testStatementCommentNotContains(regressionTest, originalStatementPos, "EXCEPTION DIFF:")) {
                        regressionTest.getTheTest().getTestCase().getStatement(originalStatementPos).addComment("EXCEPTION DIFF:\nDifferent Exceptions were thrown:\nOriginal Version:\n    " + originalException.getClass().getName() + " : " + originalException.getMessage() + "\nModified Version:\n    " + regressionExceptionMapping.get(originalStatementPos).getClass().getName() + " : " + regressionExceptionMapping.get(originalStatementPos).getMessage() + "\n");
                    }
                } else {
                    Throwable otherX;
                    String otherSourceClass;
                    Class<?> ex = RegressionExceptionHelper.getExceptionClassToUse(originalException);
                    String sourceClass = RegressionExceptionHelper.getSourceClassName(originalException);
                    if (sourceClass != null && RegressionExceptionHelper.isValidSource(sourceClass) && RegressionExceptionHelper.isExceptionToAssertValid(ex) && regressionExceptionMapping.get(originalStatementPos) != null && !sourceClass.equals(otherSourceClass = RegressionExceptionHelper.getSourceClassName(otherX = regressionExceptionMapping.get(originalStatementPos))) && RegressionExceptionHelper.testStatementCommentNotContains(regressionTest, originalStatementPos, "EXCEPTION DIFF:")) {
                        regressionTest.getTheTest().getTestCase().getStatement(originalStatementPos).addComment("EXCEPTION DIFF:\nExceptions thrown by different classes:\nOriginal Version:\n    " + sourceClass + "\nModified Version:\n    " + otherSourceClass + "\n");
                    }
                }
            }
            regressionExceptionMapping.remove(originalStatementPos);
        }
        for (Map.Entry<Integer, Throwable> regression : regressionExceptionMapping.entrySet()) {
            Throwable regressionException = regression.getValue();
            int regressionStatementPos = regression.getKey();
            if (!RegressionExceptionHelper.testStatementCommentNotContains(regressionTest, regressionStatementPos, "original version")) continue;
            RegressionExceptionHelper.addExceptionDifferenceComment(regressionTest, regressionException, regressionStatementPos, "The original version did not exhibit this exception", true);
        }
    }

    private static boolean testStatementCommentNotContains(RegressionTestChromosome test, int statementPos, String compareComment) {
        return test.getTheTest().getTestCase().hasStatement(statementPos) && !test.getTheTest().getTestCase().getStatement(statementPos).getComment().contains(compareComment);
    }

    private static void addExceptionDifferenceComment(RegressionTestChromosome test, Throwable t, int statementPos, String comment, boolean addToTestForOtherClassLoader) {
        String exceptionDiffComment = "EXCEPTION DIFF:\n" + comment + ":\n    " + t.getClass().getName() + " : " + t.getMessage() + "\n\n";
        test.getTheTest().getTestCase().getStatement(statementPos).addComment(exceptionDiffComment);
        if (addToTestForOtherClassLoader) {
            test.getTheSameTestForTheOtherClassLoader().getTestCase().getStatement(statementPos).addComment(exceptionDiffComment);
        }
    }

    private static String getSourceClassName(Throwable exception) {
        if (exception.getStackTrace().length == 0) {
            return null;
        }
        return exception.getStackTrace()[0].getClassName();
    }

    private static boolean isValidSource(String sourceClass) {
        return (!sourceClass.startsWith(PackageInfo.getEvoSuitePackage() + ".") || sourceClass.startsWith(PackageInfo.getEvoSuitePackage() + ".runtime.")) && !sourceClass.equals(URLClassLoader.class.getName()) && !sourceClass.startsWith(RegExp.class.getPackage().getName()) && !sourceClass.startsWith("java.lang.System") && !sourceClass.startsWith("java.lang.String") && !sourceClass.startsWith("sun.") && !sourceClass.startsWith("com.sun.") && !sourceClass.startsWith("jdk.internal.");
    }

    private static boolean isExceptionToAssertValid(Class<?> exceptionClass) {
        return !INVALID_EXCEPTIONS.contains(exceptionClass);
    }

    private static Class<?> getExceptionClassToUse(Throwable exception) {
        Class<?> ex = exception.getClass();
        while (!Modifier.isPublic(ex.getModifiers()) || EvoSuiteMock.class.isAssignableFrom(ex) || ex.getCanonicalName().startsWith("com.sun.")) {
            ex = ex.getSuperclass();
        }
        return ex;
    }
}

