/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.result;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.result.BranchInfo;
import org.evosuite.result.Failure;
import org.evosuite.result.MutationInfo;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.testcase.TestCase;

class TestGenerationResultImpl
implements TestGenerationResult {
    private static final long serialVersionUID = 1306033906557741929L;
    private TestGenerationResult.Status status = TestGenerationResult.Status.ERROR;
    private String errorMessage = "";
    private Map<String, Set<Failure>> contractViolations = new LinkedHashMap<String, Set<Failure>>();
    private Map<String, TestCase> testCases = new LinkedHashMap<String, TestCase>();
    private Map<String, String> testCode = new LinkedHashMap<String, String>();
    private Map<String, Set<Integer>> testLineCoverage = new LinkedHashMap<String, Set<Integer>>();
    private Map<String, Set<BranchInfo>> testBranchCoverage = new LinkedHashMap<String, Set<BranchInfo>>();
    private Map<String, Set<MutationInfo>> testMutantCoverage = new LinkedHashMap<String, Set<MutationInfo>>();
    private Set<Integer> coveredLines = new LinkedHashSet<Integer>();
    private Set<Integer> uncoveredLines = new LinkedHashSet<Integer>();
    private Set<BranchInfo> coveredBranches = new LinkedHashSet<BranchInfo>();
    private Set<BranchInfo> uncoveredBranches = new LinkedHashSet<BranchInfo>();
    private Set<MutationInfo> coveredMutants = new LinkedHashSet<MutationInfo>();
    private Set<MutationInfo> uncoveredMutants = new LinkedHashSet<MutationInfo>();
    private Set<MutationInfo> exceptionMutants = new LinkedHashSet<MutationInfo>();
    private Map<String, String> testComments = new LinkedHashMap<String, String>();
    private String testSuiteCode = "";
    private String targetClass = "";
    private String[] targetCriterion;
    private LinkedHashMap<FitnessFunction<?>, Double> targetCoverages = new LinkedHashMap();
    private GeneticAlgorithm<?> ga = null;

    TestGenerationResultImpl() {
    }

    @Override
    public TestGenerationResult.Status getTestGenerationStatus() {
        return this.status;
    }

    public void setStatus(TestGenerationResult.Status status) {
        this.status = status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.status = TestGenerationResult.Status.ERROR;
        this.errorMessage = errorMessage;
    }

    @Override
    public GeneticAlgorithm<?> getGeneticAlgorithm() {
        return this.ga;
    }

    public void setGeneticAlgorithm(GeneticAlgorithm<?> ga) {
        this.ga = ga;
    }

    @Override
    public Set<Failure> getContractViolations(String name) {
        return this.contractViolations.get(name);
    }

    public void setContractViolations(String name, Set<Failure> violations) {
        this.contractViolations.put(name, violations);
    }

    public void setClassUnderTest(String targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public String getClassUnderTest() {
        return this.targetClass;
    }

    public void setTargetCoverage(FitnessFunction<?> function, double coverage) {
        this.targetCoverages.put(function, coverage);
    }

    @Override
    public double getTargetCoverage(FitnessFunction<?> function) {
        return this.targetCoverages.containsKey(function) ? this.targetCoverages.get(function) : 0.0;
    }

    @Override
    public String[] getTargetCriterion() {
        return this.targetCriterion;
    }

    public void setTargetCriterion(String[] criterion) {
        this.targetCriterion = criterion;
    }

    @Override
    public TestCase getTestCase(String name) {
        return this.testCases.get(name);
    }

    public void setTestCase(String name, TestCase test) {
        this.testCases.put(name, test);
    }

    @Override
    public String getTestCode(String name) {
        return this.testCode.get(name);
    }

    public void setTestCode(String name, String code) {
        this.testCode.put(name, code);
    }

    @Override
    public String getTestSuiteCode() {
        return this.testSuiteCode;
    }

    public void setTestSuiteCode(String code) {
        this.testSuiteCode = code;
    }

    @Override
    public Set<Integer> getCoveredLines() {
        return this.coveredLines;
    }

    public void setCoveredLines(String name, Set<Integer> covered) {
        this.testLineCoverage.put(name, covered);
        this.coveredLines.addAll(covered);
    }

    public void setCoveredBranches(String name, Set<BranchInfo> covered) {
        this.testBranchCoverage.put(name, covered);
        this.coveredBranches.addAll(covered);
    }

    public void setCoveredMutants(String name, Set<MutationInfo> covered) {
        this.testMutantCoverage.put(name, covered);
        this.coveredMutants.addAll(covered);
    }

    @Override
    public String getComment(String name) {
        return this.testComments.get(name);
    }

    public void setComment(String name, String comment) {
        this.testComments.put(name, comment);
    }

    @Override
    public Set<Integer> getCoveredLines(String name) {
        return this.testLineCoverage.get(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String testName : this.testCases.keySet()) {
            builder.append("Test " + testName + ": \n");
            builder.append(" " + this.testLineCoverage.get(testName));
            builder.append("\n");
            builder.append(" " + this.testBranchCoverage.get(testName));
            builder.append("\n");
            builder.append(" " + this.testMutantCoverage.get(testName));
            builder.append("\n");
        }
        builder.append("Uncovered lines: ");
        builder.append(this.uncoveredLines.toString());
        builder.append("\n");
        builder.append("Uncovered branches: ");
        builder.append(this.uncoveredBranches.toString());
        builder.append("\n");
        builder.append("Uncovered mutants: " + this.uncoveredMutants.size());
        builder.append("\n");
        builder.append("Covered mutants: " + this.coveredMutants.size());
        builder.append("\n");
        builder.append("Timeout mutants: " + this.exceptionMutants.size());
        builder.append("\n");
        builder.append("Failures: " + this.contractViolations);
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public Set<BranchInfo> getCoveredBranches(String name) {
        return this.testBranchCoverage.get(name);
    }

    @Override
    public Set<MutationInfo> getCoveredMutants(String name) {
        return this.testMutantCoverage.get(name);
    }

    @Override
    public Set<BranchInfo> getCoveredBranches() {
        return this.coveredBranches;
    }

    @Override
    public Set<MutationInfo> getCoveredMutants() {
        return this.coveredMutants;
    }

    @Override
    public Set<Integer> getUncoveredLines() {
        return this.uncoveredLines;
    }

    public void setUncoveredLines(Set<Integer> lines) {
        this.uncoveredLines.addAll(lines);
    }

    @Override
    public Set<BranchInfo> getUncoveredBranches() {
        return this.uncoveredBranches;
    }

    public void setUncoveredBranches(Set<BranchInfo> branches) {
        this.uncoveredBranches.addAll(branches);
    }

    @Override
    public Set<MutationInfo> getUncoveredMutants() {
        return this.uncoveredMutants;
    }

    @Override
    public Set<MutationInfo> getExceptionMutants() {
        return this.exceptionMutants;
    }

    public void setExceptionMutants(Set<MutationInfo> mutants) {
        this.exceptionMutants.addAll(mutants);
    }

    public void setUncoveredMutants(Set<MutationInfo> mutants) {
        this.uncoveredMutants.addAll(mutants);
    }
}

