/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.evosuite.annotations.EvoSuiteTest;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.instrumentation.EvoClassLoader;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvoRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(EvoRunner.class);
    public static boolean useAgent = true;
    public static boolean useClassLoader = true;

    public EvoRunner(Class<?> klass) throws InitializationError {
        super(EvoRunner.getClass(klass));
    }

    private static Class<?> getClass(Class<?> klass) throws InitializationError {
        EvoRunnerParameters ep = klass.getAnnotation(EvoRunnerParameters.class);
        if (ep == null) {
            throw new IllegalStateException("EvoSuite test class " + klass.getName() + " is not annotated with " + EvoRunnerParameters.class.getName());
        }
        RuntimeSettings.resetStaticState = ep.resetStaticState();
        RuntimeSettings.mockJVMNonDeterminism = ep.mockJVMNonDeterminism();
        RuntimeSettings.mockGUI = ep.mockGUI();
        RuntimeSettings.useVFS = ep.useVFS();
        RuntimeSettings.useVNET = ep.useVNET();
        RuntimeSettings.useSeparateClassLoader = ep.separateClassLoader();
        RuntimeSettings.useJEE = ep.useJEE();
        if (RuntimeSettings.useSeparateClassLoader && useClassLoader) {
            return EvoRunner.getFromEvoSuiteClassloader(klass);
        }
        if (useAgent) {
            InstrumentingAgent.initialize();
        }
        InstrumentingAgent.activate();
        try {
            klass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Failed to initialize test class " + klass.getName());
        }
        InstrumentingAgent.deactivate();
        return klass;
    }

    private static Class<?> getFromEvoSuiteClassloader(Class<?> clazz) throws InitializationError {
        try {
            EvoClassLoader classLoader = new EvoClassLoader();
            classLoader.skipInstrumentation(clazz.getName());
            Thread.currentThread().setContextClassLoader(classLoader);
            return Class.forName(clazz.getName(), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError(e);
        }
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        HashSet<FrameworkMethod> testMethods = new HashSet<FrameworkMethod>();
        testMethods.addAll(this.getTestClass().getAnnotatedMethods(EvoSuiteTest.class));
        testMethods.addAll(this.getTestClass().getAnnotatedMethods(Test.class));
        return new ArrayList<FrameworkMethod>(testMethods);
    }

    @Override
    protected void validateTestMethods(List<Throwable> errors) {
        HashSet<FrameworkMethod> testMethods = new HashSet<FrameworkMethod>();
        testMethods.addAll(this.getTestClass().getAnnotatedMethods(EvoSuiteTest.class));
        testMethods.addAll(this.getTestClass().getAnnotatedMethods(Test.class));
        for (FrameworkMethod eachTestMethod : testMethods) {
            eachTestMethod.validatePublicVoidNoArg(false, errors);
        }
    }
}

