/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.FalsePositiveException;
import org.evosuite.runtime.Reflection;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.javaee.injection.InjectionList;
import org.evosuite.runtime.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateAccess {
    private static final Logger logger = LoggerFactory.getLogger(PrivateAccess.class);
    private static boolean shouldNotFailTest = true;

    public static void setShouldNotFailTest(boolean b) {
        shouldNotFailTest = b;
    }

    public static <T> void setVariable(Class<T> klass, T instance, String fieldName, Object value) throws IllegalArgumentException, FalsePositiveException {
        PrivateAccess.setVariable(klass, instance, fieldName, value, null);
    }

    public static <T> void setVariable(Class<?> klass, T instance, String fieldName, Object value, List<Class<? extends Annotation>> tagsToCheck) throws IllegalArgumentException, FalsePositiveException {
        if (klass == null) {
            throw new IllegalArgumentException("No specified class");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("No specified field name");
        }
        if (fieldName.equals("serialVersionUID")) {
            throw new IllegalArgumentException("It is not allowed to set serialVersionUID by reflection");
        }
        Field field = null;
        try {
            field = klass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            String message = "Field '" + fieldName + "' does not exist any more in class " + klass;
            if (shouldNotFailTest) {
                throw new FalsePositiveException(message);
            }
            throw new IllegalArgumentException(message);
        }
        assert (field != null);
        field.setAccessible(true);
        if (tagsToCheck != null) {
            boolean match = false;
            for (Annotation ann : ReflectionUtils.getDeclaredAnnotations(field)) {
                Class<? extends Annotation> tag = ann.annotationType();
                if (!InjectionList.isValidForInjection(tag, tagsToCheck)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new IllegalArgumentException("The field " + fieldName + " in class " + klass.getName() + "does not have any valid annotation");
            }
        }
        try {
            Reflection.setField(field, instance, value);
        }
        catch (IllegalAccessException e) {
            throw new FalsePositiveException("Failed to set field " + fieldName + ": " + e.toString());
        }
    }

    @Constraints(atMostOnce=true, notMutable=true)
    public static Object callDefaultConstructorOfTheClassUnderTest() throws Throwable {
        Class<?> cut = Thread.currentThread().getContextClassLoader().loadClass(RuntimeSettings.className);
        return PrivateAccess.callDefaultConstructor(cut);
    }

    @Constraints(atMostOnce=true, noNullInputs=true, notMutable=true)
    public static <T> T callDefaultConstructor(Class<T> klass) throws Throwable {
        Constructor<T> constructor;
        if (klass == null) {
            throw new IllegalArgumentException("No specified class");
        }
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String message = "Default constructor does not exist anymore";
            if (shouldNotFailTest) {
                throw new FalsePositiveException(message);
            }
            throw new IllegalArgumentException(message);
        }
        assert (constructor != null);
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FalsePositiveException("Failed to call the default constructor of " + klass.getName() + ": " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object[] inputs, Class<?>[] types) throws Throwable {
        if (klass == null) {
            throw new IllegalArgumentException("No specified class");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("No specified method name");
        }
        if (types == null && inputs != null || types != null && inputs == null || types != null && inputs != null && types.length != inputs.length) {
            throw new IllegalArgumentException("Mismatch between input parameters and their type description");
        }
        Method method = null;
        try {
            method = klass.getDeclaredMethod(methodName, types);
        }
        catch (NoSuchMethodException e) {
            String message = "Method " + methodName + " does not exist anymore";
            if (shouldNotFailTest) {
                throw new FalsePositiveException(message);
            }
            throw new IllegalArgumentException(message);
        }
        assert (method != null);
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(instance, inputs);
        }
        catch (IllegalAccessException e) {
            throw new FalsePositiveException("Failed to call " + methodName + ": " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return result;
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[0], new Class[0]);
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object input, Class<?> type) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{input}, new Class[]{type});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1}, new Class[]{t0, t1});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2}, new Class[]{t0, t1, t2});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3}, new Class[]{t0, t1, t2, t3});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4}, new Class[]{t0, t1, t2, t3, t4});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5}, new Class[]{t0, t1, t2, t3, t4, t5});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6}, new Class[]{t0, t1, t2, t3, t4, t5, t6});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14, Object i15, Class<?> t15) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14, Object i15, Class<?> t15, Object i16, Class<?> t16) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14, Object i15, Class<?> t15, Object i16, Class<?> t16, Object i17, Class<?> t17) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14, Object i15, Class<?> t15, Object i16, Class<?> t16, Object i17, Class<?> t17, Object i18, Class<?> t18) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4, Object i5, Class<?> t5, Object i6, Class<?> t6, Object i7, Class<?> t7, Object i8, Class<?> t8, Object i9, Class<?> t9, Object i10, Class<?> t10, Object i11, Class<?> t11, Object i12, Class<?> t12, Object i13, Class<?> t13, Object i14, Class<?> t14, Object i15, Class<?> t15, Object i16, Class<?> t16, Object i17, Class<?> t17, Object i18, Class<?> t18, Object i19, Class<?> t19) throws Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19}, new Class[]{t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19});
    }

    public static Method getCallMethod(int nParameters) {
        int max = 20;
        if (nParameters < 0 || nParameters > max) {
            logger.error("Cannot handle reflection on methods with more than {} parameters: asked for {}", (Object)max, (Object)nParameters);
            return null;
        }
        ArrayList<Class<Class>> types = new ArrayList<Class<Class>>();
        types.add(Class.class);
        types.add(Object.class);
        types.add(String.class);
        for (int i = 0; i < nParameters; ++i) {
            types.add(Object.class);
            types.add(Class.class);
        }
        try {
            return PrivateAccess.class.getDeclaredMethod("callMethod", types.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            logger.error("" + e.getMessage());
            return null;
        }
    }
}

