/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.classhandling;

import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.classhandling.ClassResetter;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStateSupport {
    private static final Logger logger = LoggerFactory.getLogger(ClassStateSupport.class);

    public static boolean initializeClasses(ClassLoader classLoader, String ... classNames) {
        boolean problem = false;
        List<Class<?>> classes = ClassStateSupport.loadClasses(classLoader, classNames);
        if (classes.size() != classNames.length) {
            problem = true;
        }
        ClassStateSupport.initialiseJacoco(classLoader, classes);
        if (RuntimeSettings.isUsingAnyMocking()) {
            for (Class<?> clazz : classes) {
                if (clazz.isInterface() || InstrumentedClass.class.isAssignableFrom(clazz)) continue;
                String msg = "Class " + clazz.getName() + " was not instrumented by EvoSuite. This could happen if you are running JUnit tests in a way that is not handled by EvoSuite, in which some classes are loaded be reflection before the tests are run. Consult the EvoSuite documentation for possible workarounds for this issue.";
                logger.error(msg);
                problem = true;
            }
        }
        return problem;
    }

    private static void initialiseJacoco(ClassLoader classLoader, List<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            try {
                Method initMethod = clazz.getDeclaredMethod("$jacocoInit", new Class[0]);
                logger.error("Found $jacocoInit in class {}", (Object)clazz.getName());
                initMethod.setAccessible(true);
                initMethod.invoke(null, new Object[0]);
                return;
            }
            catch (NoSuchMethodException initMethod) {
            }
            catch (Throwable e) {
                logger.info("Error while checking for $jacocoInit in class {}: {}", (Object)clazz.getName(), (Object)e.getMessage());
            }
        }
    }

    public static void resetClasses(String ... classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            String classNameToReset = classNames[i];
            ClassResetter.getInstance().reset(classNameToReset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> loadClasses(ClassLoader classLoader, String ... classNames) {
        ArrayList classes = new ArrayList();
        InstrumentingAgent.activate();
        boolean safe = Sandbox.isSafeToExecuteSUTCode();
        for (int i = 0; i < classNames.length; ++i) {
            Runtime.getInstance().resetRuntime();
            String classNameToLoad = classNames[i];
            Sandbox.goingToExecuteSUTCode();
            boolean wasLoopCheckOn = LoopCounter.getInstance().isActivated();
            try {
                if (!safe) {
                    Sandbox.goingToExecuteUnsafeCodeOnSameThread();
                }
                LoopCounter.getInstance().setActive(false);
                Class<?> aClass = Class.forName(classNameToLoad, true, classLoader);
                classes.add(aClass);
                continue;
            }
            catch (Error | Exception ex) {
                AtMostOnceLogger.error(logger, "Could not initialize " + classNameToLoad + ": " + ex.getMessage());
                continue;
            }
            finally {
                if (!safe) {
                    Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                }
                Sandbox.doneWithExecutingSUTCode();
                LoopCounter.getInstance().setActive(wasLoopCheckOn);
            }
        }
        InstrumentingAgent.deactivate();
        return classes;
    }

    @Deprecated
    public static void retransformIfNeeded(ClassLoader classLoader, String ... classNames) {
        ArrayList classes = new ArrayList();
        for (String name : classNames) {
            try {
                classes.add(classLoader.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not load: " + name);
            }
        }
        ClassStateSupport.retransformIfNeeded(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void retransformIfNeeded(List<Class<?>> classes) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        ArrayList classToReInstrument = new ArrayList();
        for (Class<?> cl : classes) {
            if (InstrumentingAgent.getTransformer().isClassAlreadyTransformed(cl.getName())) continue;
            classToReInstrument.add(cl);
        }
        if (classToReInstrument.isEmpty()) {
            return;
        }
        InstrumentingAgent.setRetransformingMode(true);
        try {
            if (!classToReInstrument.isEmpty()) {
                InstrumentingAgent.getInstrumentation().retransformClasses(classToReInstrument.toArray(new Class[0]));
            }
        }
        catch (UnmodifiableClassException e) {
            System.err.println("Could not re-instrument classes");
        }
        catch (UnsupportedOperationException e) {
            logger.error("EvoSuite wrong re-instrumentation: " + e.getMessage());
        }
        finally {
            InstrumentingAgent.setRetransformingMode(false);
        }
        InstrumentingAgent.deactivate();
    }
}

