/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.util.ByteDataInputStream;
import org.evosuite.shaded.javax.servlet.http.Part;

@EvoSuiteClassExclude
public class EvoPart
implements Part {
    private final String name;
    private final String body;
    private String contentType;

    @EvoSuiteInclude
    @Constraints(noNullInputs=true)
    public EvoPart(String name, String body) {
        this.name = name;
        this.body = body;
        this.contentType = null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteDataInputStream(this.body);
    }

    @Override
    public String getContentType() {
        TestDataJavaEE.getInstance().accessContentType();
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSubmittedFileName() {
        return null;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public void write(String fileName) throws IOException {
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public String getHeader(String name) {
        return null;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return null;
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextHtml"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextXml() {
        this.contentType = "text/xml";
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextXml"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextHtml() {
        this.contentType = "text/html";
    }
}

